/*******************************************************************************
  order_minkowski_bound.c 
********************************************************************************/
                                                             
#include "kant.h" 

integer_big
order_minkowski_bound WITH_1_ARG (
	order,   ord  
)
/*******************************************************************************

Description:
   
	Computes the Minkowski bound for a given number field.
	The given order should be the maximal order.
                                                    

Calling sequence:
                                                           
	      mink  = order_minkowski_bound (ord);                       
 
          order ord        :  The order has to be the ring of integers of 
                              a number field. 

          integer_big mink :  the minkowski - bound for the number - field 
                              associated with ord.

                                                             
                            
History:                                 
                    
   JS 08.05.92    everything long
   JS 07.05.92    order_disc_assure
   MD 09.04.92    order_disc (ord) might be negative: so integer_abs added.                                               
   MD 17.02.92    written

********************************************************************************/
{
	block_declarations;         
 
        t_handle             R;
   
        t_real             droot, b, temp1, temp2, temp3, fac, power, four, pi;
        integer_big        i_temp, mink;
        integer_small      n, r2;
                        
  order_disc_assure(ord);  
 
  R   = real_str_create(20);
  n   = order_abs_degree(ord);
  r2  = order_r2 (ord);                     
      
  i_temp = integer_abs (order_disc (ord));
  temp1  = conv_int_to_real (R,i_temp);
  droot  = real_sqrt (R,temp1);  

  integer_delref (i_temp);
  real_delete (&temp1);

/* Calculate some constants for the Minkowski - bound */

  i_temp = integer_nfactorial(n);        
  fac    = conv_int_to_real(R, i_temp);
  integer_delref (i_temp);
  
  i_temp = integer_power (n, n);
  power  = conv_int_to_real(R, i_temp);
  integer_delref (i_temp);      
             
  four = conv_int_to_real(R, 4);
  pi   = real_pi(R);
 
  temp1 = real_divide(R, four, pi);
  temp2 = real_power(R, temp1, r2);
  temp3 = real_divide(R, fac, power);
  b     = real_mult(R, temp3, temp2);
  
  real_delete(&fac);
  real_delete(&power);
  real_delete(&four);
  real_delete(&pi);
  real_delete(&temp1);
  real_delete(&temp2);
  real_delete(&temp3);
 
  temp1 = real_mult(R, b, droot);
 
  mink = conv_real_to_int_ceil(R, temp1);
 
  real_delete(&droot);
  real_delete(&b);
  real_delete(&temp1);
  ring_delete(&R);
 
  if (anf_print_level > 0) cay_print("Minkowski bound: %d\n",mink);
 
  return mink;
}

