/******************************************************************************
  order_reals_create.c
******************************************************************************/

#include "kant.h"
#include "anf.h"

void
order_reals_create WITH_1_ARG(
	order,		ord
)
/*******************************************************************************
 
Description:

        (Re-)Sets all order related real approximations.
        The default precision is 20.
 
 
Calling sequence:
 
	order_reals_create(ord)
 
      	order         ord      = t_handle of order 
      
 
History:
 
	92-03-19 JS	renaming into order_reals_*
	92-02-25 JS	default precision is 20
	91-10-10 JS    	minor changes
	91-10-01 JS    	written
  
  
*******************************************************************************/
{
	block_declarations;
                  
	if (!order_reals_known(ord)) order_reals_set(ord, 20);

	order_basis_real_create(ord);
	order_units_logs_calc(ord);
 
	if (order_units_are_maximal(ord)) order_reg_calc(ord);
 
	return;
}
