#include "kant.h"

anf_elt
order_shortest_primitive_elt WITH_1_ARG(
	order,		ord
)
/*******************************************************************************
 
Description:
 
	The function returns a primitive element of ord 
  	with shortest T_2-norm.

 
Calling sequence:
 
	alpha= order_shortest_primitive_elt(ord);
 
      	order  	        ord      = t_handle of an order 
      	anf_elt         alpha    = t_handle of a primitive algebraic number 
				   in ord with shortest T_2-Norm
      
 
History:
 
	92-07-06 JS    order_reals_assure
	92-04-02 AJ    written
 
*******************************************************************************/
{  
	block_declarations;         

  	int		i, n, deg;
   	t_handle          R;
        t_real          ubound, acc_short_length;

	order		ord_equation;
	anf_elt 	alpha, tst_elt;

	lattice 	lat;
	lat_enum_env	env; 


/*** Initialisation  **********************************************************/
                        
	n=  order_abs_degree(ord);
        
        order_reals_assure(ord);

        R = order_reals(ord);    

/*** Computation of an upper bound of a primitive element  *******************/   
    
	alpha= order_primitive_elt(ord);

	ubound= anf_elt_t2(ord, alpha);

	if (anf_print_level > 3)
	 {
	  printf("\nA primitive element: ");
	  anf_elt_write(ord, alpha);
	  printf("\nUpper T2 bound for a primitive element: ");
          real_write(R, ubound, 10); printf("\n");
         }

/*** Initialisation of enumeration environment  ******************************/

	order_lat(ord, &lat, &env);

	lat_enum_ubound(env) = real_incref(ubound);
	acc_short_length = real_incref(ubound);

	lat_enum_status_set_new(env);
	lat_enum_request_set_next(env);

/*** Loop of the enumeration   ***********************************************/

	while (lat_enum(lat,env))
	{  

         /*** Test if the founded element is shorter than the last       ****/
         /*** primitive element                                          ****/
                   
	 if (real_compare(R, lat_enum_act_length(env),acc_short_length)== -1)
	  {               

	   /** Construction of the algebraic element from the lattice vector **/

	   tst_elt= lat_elt_to_anf_elt(lat, lat_enum_act_coefs(env), ord);


	   if (anf_elt_is_primitive(ord,tst_elt))
	     {      
 	      /** Storing the shorter primitive element                      **/

	      real_delete(&acc_short_length);
	      acc_short_length= real_incref(lat_enum_act_length(env));
	      anf_elt_delref(ord,&alpha);
	      alpha= anf_elt_incref(tst_elt);
	     } 

	   anf_elt_delref(ord,&tst_elt);

	  } /* endif: real_compare */

	}   /* end while */ 
	
/*** End: return the primitive element  ***************************************/
                                    
	lat_enum_delete(lat,&env);
	lat_delete(&lat);
	real_delete(&ubound);
	real_delete(&acc_short_length);

	return alpha;

} 

