/******************************************************************************
  order_units_calc.c                                                           
******************************************************************************/
                  
#include "kant.h" 
 
t_void
order_units_calc WITH_1_ARG(
	order,		ord
)
/*******************************************************************************

Description: 
 
 	Tries to compute an independent system of units
        in ord recursively (using all subfield orders).
               
 
Calling sequence: 
	
	order_units_calc(ord);
                               
	order		ord    = t_handle of the order 

  
History:

 	92-09-01 JS 	different output
 	92-06-10 JS 	Voronoi
 	92-05-15 JS 	first version
  
*******************************************************************************/
{
	block_declarations;
 
        order		subord;
        integer_small   i, j, cnt, ucnt;
        anf_elt         unit;
                          
        if (order_units_are_maximal(ord)) return;
             
        order_mult_assure(ord);
        order_reals_assure(ord);

        if (anf_print_level > 0) 
	printf("Assuring units in order of absolute degree %d...\n", 
		order_abs_degree(ord)); 
 
        cnt = order_subfield_order_count(ord);
 
        if (anf_print_level > 1) 
        {
	        if (cnt)
			printf("Computation of units in %d subfield order(s)...\n", cnt);
                else
	                puts("No subfield order given => direct unit computation.");
        }
 
        for (i=1; i<=cnt; ++i)
	{                                        
                subord = order_subfield_order(ord, i);
 
	        if (anf_print_level > 2) 
		printf("Units in order of absolute degree %d...\n", 
			order_abs_degree(subord)); 
                                        
                anf_print_level--;
                order_units_calc(subord);   
                anf_print_level++;
 
                ucnt = order_units_count(subord);
 
	        if (anf_print_level > 2)
			printf("Start lifting %d unit(s)...\n", ucnt);
 
                for (j=1; j<=ucnt; ++j)
                {
                        unit = anf_elt_lift_up(subord, order_unit(subord, j), ord);
                        if (anf_print_level > 2) 
                        {
                                printf("Unit: "); anf_elt_write(subord,  order_unit(subord, j));
                                printf("  =  "); anf_elt_write(ord, unit); puts("");
                        }

                        anf_elt_factorize(ord, unit);
                        anf_elt_delete(ord, &unit);
                }
        }
         
        ucnt = order_relation_count(ord);
        if (anf_print_level  > 1 && cnt) 
		printf("Number of relations now: %d\n", ucnt); 
 
        if (ucnt) order_relation_eval_units(ord);

        ucnt = order_units_count(ord);
 
        if (anf_print_level  > 0 && cnt) 
		printf("Number of independent units now: %d\n", ucnt); 
                                           
/*
    if the unit system is not maximal we have to do some work
*/
        if (!order_units_are_maximal(ord)) 
        {
                if (order_r(ord) == 1)          
                {
                        order_units_voronoi(ord);
                }
                else
                {
                        order_relation_delete(ord);
			order_units_relations(ord);
                }
        }
        return;
}
