

#include "defs.h"
#include "ring.e"
#include "comp.e"

t_void
comp_cart_to_polar WITH_5_ARGS(
	t_handle,		r,
	mp_float,	are,
	mp_float,	aim,
	mp_float *,	amod,
	mp_float *,	arg
)
/*
** Given the real and imaginary parts of the complex number a,
** returns the modulus and argument in amod and arg.
*/
{
	t_comp	c;
	mp_float cre, cim;
	t_real temp_r;

	c = comp_alloc( real_base, comp_beta_prec( r ));
	comp_split_mp (c, cre, cim);
	cre = are;
	cim = aim;
	temp_r = comp_modulus (r, c);
	real_make_mp (temp_r, (*amod));
	temp_r = comp_arg (r, c);
	real_make_mp (temp_r, (*arg));
	comp_delete (&c);
}
