
#include "defs.h"
#include "mp.e"
#include "comp.e"

t_comp
comp_divide WITH_3_ARGS(
	t_handle,		r,
	t_comp,		a,
	t_comp,		b
)
/*
** Returns a / b.
*/
{
	t_comp		c, d;
	mp_float	bre, bim, cre, cim, dre, dim;
	mp_float	temp1, temp2, temp3;

	temp1 = mp_alloc( real_base, comp_beta_prec( r ));
	temp2 = mp_alloc( real_base, comp_beta_prec( r ));
	temp3 = mp_alloc( real_base, comp_beta_prec( r ));

	comp_split_mp( b, bre, bim );

	c = comp_alloc( real_base, comp_beta_prec( r ));
	comp_split_mp( c, cre, cim );

	mp_priv_copy( bre, cre );
	mp_neg( bim, cim );
	d = comp_mult( r, a, c );
	comp_split_mp( d, dre, dim );

	mp_mul( bre, bre, temp1 );
	mp_mul( bim, bim, temp2 );
	mp_add( temp1, temp2, temp3 );

	mp_div( dre, temp3, cre );
	mp_div( dim, temp3, cim );

	mp_delete_float( temp1 );
	mp_delete_float( temp2 );
	mp_delete_float( temp3 );
	comp_delete( &d );

	return c;
}

