#include "defs.h"
#include "mp.e"
#include "mp.h"
#include <math.h>
#include "debug.e"



mp_float
conv_double_to_mp		WITH_2_ARGS(
	double,		d,
	mp_float,	x
)
/*
Converts the (machine) double d to the mp float x and returns x.
*/
{
    mp_ptr_type		xp = mp_ptr(x);
    mp_sign_type	sign;
    mp_base_type	b;
    mp_length		t, i;
    mp_expt_type	expt;

	IF_DEBUG_FLAG(DEBUG_MP,
	{
		cay_print("conv_double_to_mp : d = %f, x = %d", d, x);
	}
	);


    if (!d)
    {
	mp_set_sign(xp, 0);

	return x;
    }


    if ((sign = int_sign(d)) < 0)
	d = -d;


    /*
    Reduce d to the range 1/16 <= d < 1.
    */

    expt = 0;

    while (d >= 1)
    {
	expt++;
	d *= 0.0625;
    }

    while (d < 0.0625)
    {
	expt--;
	d *= 16;
    }

    b = mp_b(xp);
    t = mp_t(xp);

    for (i = 0; i < t; i++)
    {
	mp_int		dig;


	d *= b;

	if (d < 0 || (dig = floor(d)) >= b)
	    break;

	mp_set_digit(xp, i, dig);

	d -= dig;
    }

    if (i < t)
    {
	/*
	Something strange happened.  Either a digit is negative, or it is
	greater than or equal to b, both of which should never happen.
	Fill in the rest of the digits with an appropriate value.
	*/

	mp_int		fill = (d < 0)? 0: b - 1;

	for (; i < t; i++)
	   mp_set_digit(xp, i, fill);
    }


    mp_nzr(sign, 0, xp, mp_digit_ptr(xp, 0), 0);


    /*
    Now multiply by 16^expt.
    */

    mp_scale(x, 16, expt);

    return x;
}


double
conv_mp_to_double	WITH_1_ARG(
	mp_float,	x
)
/*
Returns the (machine) double value of the mp number x.
*/
{
    double		d;
    mp_ptr_type		xp = mp_ptr(x);
    mp_length		t, i;
    mp_base_type	b;
    mp_expt_type	expt;


    if (mp_is_zero(xp))
	return 0;

    b = mp_b(xp);
    t = mp_t(xp);

    d = 0;

    for (i = 0; i < t; i++)
    {
	double	d1;

	d *= b;
	d += mp_digit(xp, i);

	/*
	Check if full double-precision accuracy is attained.
	*/

	d1 = d + 1;

	if (d1 - d <= 0)
	    break;
    }


    /*
    Now allow for exponent.
    */

    if (i == t)
	i--;

    
    if ((expt = mp_expt(xp) - i - 1) > 0)
	while (expt > 0)
	{
	    expt--;
	    d *= b;
	}

    else
	while (expt < 0)
	{
	    expt++;
	    d /= b;
	}

    if (mp_is_neg(xp))
	d = -d;

    return d;
}
