#include "defs.h"
#include <math.h>
#include "integer.e"
#include "modint.e"
#include "inthdl.e"
#include "intbig.h"
#include "faclst.e"
#include "faclst.h"
#include "dyn_arr.e"
#include "dyn_arr.h"
#include "prime_cert.e"
#include "prime_cert.h"

#define	MINEXTN	2

Logical
i_pocklington_primality_test WITH_5_ARGS(
    integer_big,           n,
    integer_big,           nmin1,
    faclst,               nmin1fct,
    integer_big,           orest,
    prime_cert_handle,     certificate
)
/*
** Input:  n - general integer >= 3
**	   nmin1 - general integer = n - 1
**	   nmin1fct - prime factor stack of factored part of nmin1
**	   orest - non-factored part of nmin1
** Output: 	 TRUE if n is found to be prime
**		FALSE if n is found to be non-prime
** For sufficiently many primes q dividing n - 1 an integer a is found
** such that a^((n-1)/q) - 1  is coprime to n. Such a proves that the
** order of Z/nZ^* is divisible by q^k, where q^k || n-1.
**/
{
	block_declarations;

	integer_big		quot;
	integer_big		fact;
	integer_big		rem;
	register integer_big	dif;
	register integer_big	exp;
	register integer_big	gcd;
	Logical			tryrest;
	Logical			aflag;
	register integer_big	qindex;
	integer_big		cindex;
	integer_big		it;
	register t_int	q;
	register integer_big	i;
	register integer_big	j;
	register t_int	a;
	register integer_big	apow;
	register integer_big	b;
	register t_int	noprimes;
	register integer_big	temp;
	Logical			wantcert;
	integer_big             rest;

	rest = integer_incref( orest );

	DEBUG_INTEGER_0(".pocklington: ");
	DEBUG_INTEGER_2("n, n-1 = ", n, nmin1);
	DEBUG_INTEGER_0("n-1 fact: ");
#ifdef DEVELOP
	if (intbig_debug_flag)
		faclst_print(nmin1fct);
#endif
	DEBUG_INTEGER_1("rest = ", rest);
	DEBUG_INTEGER_0("cert: ");

#ifdef DEVELOP
	if (intbig_debug_flag)
		prime_cert_print(certificate);
#endif

	wantcert = certificate != 0;
	/*
	 * Multiply all q's.
	 */
	quot = 1;
	fact = 1;
	noprimes = faclst_num_prime(nmin1fct);
	for (qindex = 0; qindex < noprimes; qindex++)
	{
		q = faclst_prime(nmin1fct, qindex);	/* q temporary */
		exp = faclst_expon(nmin1fct, qindex);
		while(exp > 1)
		{
			temp = quot;		/* transfer reference */
			quot = modint_mult(n, q, temp);
			integer_delref(temp);
			--exp;
		}

		temp = fact;		/* transfer reference */
		fact = modint_mult(n, q, temp);
		integer_delref(temp);
	}

	/*
	** Now, fact = (product of primes),
	** quot = (product of (primes to exp-1 power))
	**
	** Next,  fact *= quot,  quot *= rest
	*/

	temp = fact;			/* transfer reference */
	fact = modint_mult( n, temp, quot );
	integer_delref( temp );

	temp = quot;			/* transfer reference */
	quot = modint_mult( n, temp, rest );
	integer_delref( temp );

	DEBUG_INTEGER_1("factored part F of n-1 equals ", fact);

	if (wantcert)
		it = prime_cert_curr_length(certificate);

	cindex = integer_mult(fact, fact);
	if (integer_compare(cindex, nmin1) > 0)
	{
		integer_delref( rest );
		rest = 1;
	}
	else
	{
		++it;
		if (wantcert)
		{
			prime_cert_assure_space(certificate, it, MINEXTN);
			prime_cert_prime(certificate,it-1) = integer_incref(n);
			prime_cert_div(certificate,it-1) = 0;
			prime_cert_base(certificate,it-1) = 0;
			prime_cert_curr_length(certificate) = it;
		}
	}

	integer_delref(cindex); 

	cindex = 0;
	DEBUG_INTEGER_1("we need unfactored part R of n-1 equal to ", rest);
	/*
	 * Main loop
	 */
	tryrest = integer_compare(rest, 1) != 0;
	a = 2;
	while (integer_compare(a, nmin1) <= 0)
	{
		aflag = FALSE;  /* have we tested  a^{n-1} = 1 mod n yet ? */
		if(tryrest)
		{
			apow = modint_exp(n, a, fact);
			/* added the following line: */
			b = integer_add( apow, -1 );

			DEBUG_INTEGER_2("(A) in the power F is (B) ", a, apow);
			gcd = integer_gcd(b, n);
			DEBUG_INTEGER_1("gcd equals ", gcd);
			integer_delref( b );

			if (integer_compare(gcd, 1) == 0)
			{
				/* we have dealt with composite rest */

				/* fake delref of gcd */

				temp = apow;           /* transfer reference */
				apow = modint_exp(n, temp, rest);
				integer_delref(temp);

				if(integer_compare(apow, 1) ==0)
				{
					DEBUG_INTEGER_1("deals with R= ", rest);
					if (wantcert)
					{
						prime_cert_div(certificate,
    it-cindex-1) = integer_incref( rest );
						prime_cert_base(certificate,
    it-cindex-1)= integer_negate(a);
					}
					cindex+=1;
					if(noprimes ==0)
					{
						/* fake delref apow, apow==1 */
						integer_delref(fact);
						integer_delref(quot);
						integer_delref(rest);
						DEBUG_INTEGER_0("taken exit 1");
						return TRUE;
					}
					aflag = TRUE;
					tryrest = FALSE;
					/* fake delref of apow */
				}
				else
				{
					integer_delref(apow);
					integer_delref(rest);
					integer_delref(fact);
					integer_delref(quot);
					DEBUG_INTEGER_0("taken exit 2");
					return FALSE;
				}
			}
			else if(integer_compare(gcd, n) == -1)
			{	/* we found a factor of n ... */
				integer_delref(apow);
				integer_delref(gcd);
				integer_delref(rest);
				integer_delref(fact);
				integer_delref(quot);
				DEBUG_INTEGER_0("taken exit 3");
				return FALSE;
			}
			else
				integer_delref( gcd );

			integer_delref(apow);
		}
		apow = modint_exp(n, a, quot);
		for(qindex =0; qindex < noprimes; qindex++)
		{
			b = integer_incref(apow);
			for(i=0; i < noprimes; i++)
			{
				if(i != qindex)
				{
					q = faclst_prime(nmin1fct, i);
					temp = b;		/* transfer */
					b = modint_exp(n, temp, q);
					integer_delref(temp);
				}
			}

			DEBUG_INTEGER(("(A) in the power (n-1)/(B) is (C)", 3,
				a, faclst_prime(nmin1fct, qindex), b));
			dif = integer_subtract(b, 1);
			gcd = integer_gcd(dif,n);
			integer_delref(dif);
			DEBUG_INTEGER_1("gcd equals ", gcd);
			if (integer_compare(gcd, 1) == 0)
			{
				/* we have dealt with present q */

				/* fake delref of gcd */

				q = faclst_prime(nmin1fct, qindex);
				if(!aflag)
				{
					temp = b;		/* transfer */
					b = modint_exp(n, temp, q);
					integer_delref(temp);

					if(integer_compare(b, 1) != 0)
					{
						integer_delref(apow);
						integer_delref(b);
						integer_delref(rest);
						integer_delref(fact);
						integer_delref(quot);
						DEBUG_INTEGER_0("taken exit 4");
						return FALSE;
					}
				}
				DEBUG_INTEGER_1("that deals with q= ",q);
				if (wantcert)
				{
					prime_cert_div(certificate,
    it-cindex-1) = integer_incref(q);
					prime_cert_base(certificate,
    it-cindex-1) = a;
				}
				cindex+=1;
				if(noprimes ==1 && !tryrest)
				{
					integer_delref(apow);
					integer_delref(b);
					integer_delref(rest);
					integer_delref(fact);
					integer_delref(quot);
					DEBUG_INTEGER_0("taken exit 5");
					return TRUE;
				}

				temp = apow;		/* transfer */
				apow = modint_exp(n, temp, q);
				integer_delref(temp);

				temp = quot;		/* transfer */
				quot = integer_mult(temp, q);
				integer_delref(temp);

				/*
				** q is an alias for prime of qindex
				*/
				integer_delref(q);

				for(j = qindex; j<(noprimes-1); j++)
					faclst_prime(nmin1fct, j)
						= faclst_prime(nmin1fct, j+1);
				faclst_reduce(nmin1fct, noprimes-1);
				faclst_num_prime(nmin1fct) = noprimes - 1;
				qindex -= 1;
				noprimes -= 1;
			}
			else if(integer_compare(gcd, n) == -1)
			{
				/* we found a factor of n ... */
				integer_delref(apow);
				integer_delref(b);
				integer_delref(gcd);
				integer_delref(rest);
				integer_delref(fact);
				integer_delref(quot);
				DEBUG_INTEGER_0("taken exit 6");
				return FALSE;
			}
			integer_delref(b);
			integer_delref(gcd);
		}

		integer_delref(apow);
		++a;
	}

	DEBUG_INTEGER_0("we ran out of bases ... should not happen!");
	integer_delref(rest);
	integer_delref(fact);
	integer_delref(quot);
	DEBUG_INTEGER_0("taken exit 7");
	return FALSE;      /* Failure: this should never happen */
}
