/*  integer_abs.c
*/

#include "defs.h"
#include "integer.e"
#include "inthdl.e"
#include "intbig.h"


integer_big
integer_abs	WITH_1_ARG(
    integer_big, i
)
/*
Return the absolute value of i.
*/
{
    inthdl_handle	h;

    if (integer_is_single(i))
	return i < 0 ? -i : i;

    h = inthdl_big_to_handle(i);

    if (intbig_sign(h) < 0)
	return integer_negate(i);
    else
    {
	inthdl_incref(h);
	return i;
    }
}
