/*  integer_compare.c
*/

#include "defs.h"
#include "integer.e"
#include "inthdl.e"
#include "intbig.h"

t_int
integer_compare WITH_2_ARGS(
    integer_big, a,
    integer_big, b
)
/*
Return -1, 0, or 1 according as the big integer a is numerically less than,
equal to, or greater than the big integer b, respectively.
*/
{
    intbig_medium	diff_sign;
    inthdl_handle	ahdl;
    inthdl_handle	bhdl;
    inthdl_length	alen;
    register inthdl_length	blen;

    if (integer_is_single(a))
    {
	if (integer_is_single(b))
	    diff_sign = a - b;
	else
	{
	    /*
	    here b has greater absolute value than a, so b's sign
	    determines the result
	    */
	    bhdl = inthdl_big_to_handle(b);
	    diff_sign = -intbig_sign(bhdl);
	}
    }
    else if ((ahdl=inthdl_big_to_handle(a)), integer_is_single(b))
    {
	/*
	a has greater absolute value than b
	*/
	diff_sign = intbig_sign(ahdl);
    }
    else
	return inthdl_compare(ahdl, inthdl_big_to_handle(b));

    return diff_sign < 0 ? -1 : (diff_sign > 0);
}
