#include "defs.h"

Void
integer_ppart(m, flag, p, n, exact)
t_int	m;
Logical	flag;
t_int	p;
t_int	*n;
Logical	*exact;
{
	register t_int	a;
	register t_int	i;
	register t_int	k;
	register t_int	q;

	/*
	 * Given m and p the routine expresses
	 * m = ( p ** n ) * c
	 * where p does not divide c. If flag is true then m is a
	 * factored integer stack.
	 * n returns the exponent of p and 'exact' is true iff m = p**n
	 */
	*n = 0;
	*exact = FALSE;
	if (p <= 1)
		error_internal( "bad value of p, cannot calculate ppart\n" );
	if (flag)
	{
		/*
		 * m is a factored integer stack
		 */
		k = sh_ffld(m, 1, 1);
		for (i = 1; i <= k; i++)
		{
			q = sh_ffld(m, i + 1, 1);
			if (p == q)
			{
				*n = sh_ffld(m, i + 1, 2);
				if (k == 1)
					*exact = TRUE;
				break;
			}
		}
	}
	else
	{
		/*
		 * m is an integer
		 */
		a = m;
		while (a % p == 0)
		{
			a /= p;
			++*n;
		}
		if (a == 1)
			*exact = TRUE;
	}
}
