#include "defs.h"
#include "integer.e"
#include "inthdl.e"
#include "intbig.h"

void
integer_sqrt    WITH_3_ARGS(
    integer_big,       aint,
    integer_big *,     sqrt,
    t_int *,   sign
)
/*
** input:  aint - non-negative general integer (single or infinite-precision)
** output: sqrt - general integer = floor (sqrt (aint))
** sign - sign of (aint - sqrt ** 2)
** sqrt computes integer square root.  sqrt is equal to the largest integer
** less than or equal to the square-root of aint.  sign is 0 if aint is
** a perfect square and -1 otherwise.
*/
{
    register inthdl_length  alen;
    register inthdl_handle  ahdl;
    register inthdl_handle  shdl;

    /*
     * case aint is single-precision?
     */

    if (integer_is_single( aint ))
    {
	ib_sqrt(aint, sqrt, sign);
	return;
    }

    /*
     * case aint is infinite-precision...
     */

    ahdl = inthdl_big_to_handle( aint );
    alen = intbig_curr_size( ahdl );

    /*
     * allocate storage for result
     */

    shdl = inthdl_alloc( alen / 2 + 1 );

    inthdl_sqrt(ahdl, shdl, sign);

    /*
     * convert result to a general integer
     */

    *sqrt = inthdl_standardize( shdl );
}
