#include "defs.h"
#include "ring.h"
#include "mat.h"
#include "integer.e"

t_void
mat_ring_mult_sub WITH_4_ARGS(
	t_handle,		cring,
	matrix,		a,
	matrix,		b,
	matrix *,	pc
)
/*
** Multiplies matrix a by matrix b, both over coefficient ring cring.
** a is (am X an), matb is (bm X bn).
** Result to be stored in *pc (am X bn) if allocated, otherwise *pc assigned.
*/
{
	block_declarations;
	register t_int	i;
	register t_int	j;
	register t_int	k;
	register integer_big	s;
	register t_int	am;
	register t_int	an;
	register t_int	bm;
	register t_int	bn;
	matrix	mata;
	matrix	matb;
	matrix	matc;
	t_int	temp1;
	t_int	temp2;
	Logical	respack;
	t_ring_elt	(*ringadd)();
	t_ring_elt	(*ringmult)();

	switch ( ring_type( cring ) )
	{

	case RING_Z:
		mat_z_mult_sub( cring, a, b, pc );
		return;

	case RING_ZM:
		mat_zm_mult_sub( cring, a, b, pc );
		return;

	default:
		break;
	}

	am = mat_row(a);		an = mat_col(a);
	bm = mat_row(b);		bn = mat_col(b);

	if (an != bm)
		error_internal("Incompatible matrices for multiplication, %d,%d by %d,%d\n", am, an, bm, bn);

	/*
	 * This is important!
	 * because mat[abc] are not allocated.
	 */
	mata = matb = matc = 0;

	respack = mat_result_pkd(cring, *pc);
	mat_alloc_result_unpkd(respack, *pc, matc, am, bn);
	mat_create_unpkd(cring, a, mata, am, an);
	/*
	 * if a and b are the same matrix, don't unpack b
	 */
	if (a != b)
	{
		mat_create_unpkd(cring, b, matb, bm, bn);
	}
	else
		matb = mata;

	ringadd = ring_addition( cring );
	ringmult = ring_multiplication( cring );

	/*
	 * i represents the row number of matc
	 */
	for (i = 1; i <= am; ++i)
	{
		/*
		 * j represents the column number of matc
		 */
		for (j = 1; j <= bn; ++j)
		{
			s = ring_zero( cring );
			for (k = 1; k <= an; ++k)
			{
				temp1 = s;
				temp2 = (*ringmult)(cring, mat_elt(mata, i, k), mat_elt(matb, k, j));
				s = (*ringadd)(cring, temp1, temp2);
				ring_elt_delete( cring, &temp1 );
				ring_elt_delete( cring, &temp2 );
			}
			mat_elt(matc, i, j) = s;
		}
	}
	mat_create_result(cring, respack, *pc, matc);
	mat_free_unpkd(a, mata);
	/*
	 * Free only if a and b were different
	 */
	if (a != b)
		mat_free_unpkd(b, matb);

	return;
}


matrix 
mat_ring_mult WITH_3_ARGS(
	t_handle,	cring,
	matrix,	a,
	matrix,	b
)
/* 
** Returns a * b, where a and b are matrices over coefficient ring cring.
*/
{
	matrix c = 0;
	mat_ring_mult_sub(cring, a, b, &c);
	return c;
}
