#include "defs.h"
#include "ring.h"
#include "mat.h"
#include "zm.e"

void
mat_zm_negate_sub WITH_3_ARGS(
	t_handle,	cring,
	matrix,	a,
	matrix	*,	result
)
/*
** *result := - a, a is a matrix over integer module cring.
*/
{
	Logical respack;
	t_int		m;
	t_int		n;
	matrix	adash;
	matrix	resultdash;
	t_int		modulus;
	t_int		i;

	adash = resultdash = 0;
	modulus = zm_modulus(cring);
	respack = mat_result_pkd(cring, *result);
	m = mat_row(a);
	n = mat_col(a);

	mat_alloc_result_unpkd(respack, *result, resultdash, m ,n);
	mat_create_unpkd(cring, a, adash, m, n);

	for (i = 1; i <= m*n; i++)
	{
		mat_entry(resultdash, i) = modint_negate(modulus, mat_entry(adash, i));
	}

	mat_create_result(cring, respack, *result, resultdash);
	mat_free_unpkd(a, adash);
}


matrix 
mat_zm_negate WITH_2_ARGS(
	t_handle,	cring,
	matrix,	a
)
/*
** Returns - a matrix over integer module cring.
*/
{
	matrix	result = 0;
	mat_zm_negate_sub(cring, a, &result);
	return result;
}

