#include "defs.h"
#include "ring.h"
#include "mat.h"
#include "zm.e"

void
mat_zm_subtract_sub WITH_4_ARGS(
	t_handle,	cring,
	matrix,	a,
	matrix,	b,
	matrix	*,	result
)
/*
** *result := a - b, a and b matrices over integer module cring.
*/
{
	Logical respack;
	t_int		ma;
	t_int		na;
	t_int		mb;
	t_int		nb;
	matrix	adash;
	matrix	bdash;
	matrix	resultdash;
	t_int		modulus;
	t_int		i;

	adash = bdash = resultdash = 0;
	ma = mat_row(a);
	na = mat_col(a);
	mb = mat_row(b);
	nb = mat_col(b);
	if ((ma != mb) || (na != nb))
		error_internal("The matrics have different dimensions in mat_zm_subtract_sub");

	modulus = zm_modulus(cring);
	respack = mat_result_pkd(cring, *result);

	mat_alloc_result_unpkd(respack, *result, resultdash, ma, na);
	mat_create_unpkd(cring, a, adash, ma, na);
	mat_create_unpkd(cring, b, bdash, ma, na);

	for (i = 1; i <= ma*na; i++)
		mat_entry(resultdash, i) = modint_subtract(modulus, mat_entry(adash, i), mat_entry(bdash, i));
			
	mat_create_result(cring, respack, *result, resultdash);
	mat_free_unpkd(a, adash);
	mat_free_unpkd(b, bdash);
}


matrix 
mat_zm_subtract WITH_3_ARGS(
	t_handle,	cring,
	matrix,	a,
	matrix,	b
)
/*
** Returns a - b, a and b matrices over integer module cring.
*/
{
	matrix	result = 0;
	mat_zm_subtract_sub(cring, a, b, &result);
	return result;
}

