#include "modint.e"

integer_big
modint_invert WITH_2_ARGS(
	integer_big,	mint,
	integer_big,	aint
)
/*
** modint_invert : modular integer inverse. 
** mint is a positive integer, aint is a unit of Zmint
** returns inverse of aint
** If aint is not invertible, then 0 is returned.
*/
{
	block_declarations;
	integer_big	gcdint;
	integer_big	uint;
	integer_big	resint;
	integer_big	temp;

	/* aint is a unit of Zmint */

	integer_gcd_mult( mint, aint, &gcdint, &uint, &resint );

	if ( gcdint != 1 )
	{
		return 0;
	}

	integer_delref( gcdint );
	integer_delref( uint );

	/* ensure result is positive but reduced mod mint */

	if ( integer_sign( resint ) < 0 )
	{
		temp = resint;
		resint = integer_add( mint, temp );
		integer_delref( temp );

		return resint;
	}

	return  resint;
}

