#include "modint.e"

integer_big
modint_mult_f WITH_3_ARGS(
	integer_big,	mint,
	integer_big,	aint,
	integer_big,	bint
)
/*
** modint_mult : modular integer product
** function sitting under modint_mult() macro.
** mint:	positive integer
** aint, bint are elements of Zmint
** returns aint * bint , an element of Zmint
*/
{
	block_declarations;
	integer_big	temp;
	integer_big	result;

	if ( mint < DELTA )
	{
		return ( aint * bint ) % mint;
	}

	if (integer_is_single(mint))
	{
		t_int	carry, prod, quot, rem;

		ib_mult(aint, bint, &carry, &prod);
		ib_quot_rem(carry, prod, mint, &quot, &rem);
		return rem;
	}

	temp = integer_mult(aint, bint);
	result = integer_rem(temp, mint);

	integer_delref(temp);
	return(result);
}
