#include "defs.h"
#include "integer.e"
#include "poly.h"
#include "zm.e"
#include "error.e"

t_poly
modpoly_subtract WITH_4_ARGS(
        t_handle,       pring,
        integer_big,    mdig,
        t_poly,    apoly,
        t_poly,    bpoly
)
/*
** modpoly_subtract: modular polynomial difference
** apoly and bpoly are polynomials over Zmdig.
** returns : ( apoly - bpoly ) mod mdig .
*/
{
    block_declarations;
    t_poly        temp;
    t_poly        result;

    if ( ( m_poly_const( apoly ) ) && ( m_poly_const( bpoly ) ) ) 
    {
        return  modint_subtract( mdig, apoly, bpoly );
    }

    if (m_poly_const (apoly) || m_poly_const (bpoly))
    {
        error_internal ("modpoly_subtract: polys not lifted\n");
        return NULL_POLYNOMIAL;
    }

    /* both non-consts */

    temp = modpoly_negate( pring, mdig, bpoly );
    result = modpoly_add( pring, mdig, apoly, temp );
    m_modpoly_delref( pring, temp );

    return result;
}

