#include "defs.h"
#include "mp.e"


mp_vector
mp_vector_alloc WITH_1_ARG(
        mp_int,         dim
)
/*
Returns an allocated mp_vector with room for dim floats.
*/
{
    mp_float_array      h;

    h = mem_alloc_words_zero(MP_VECTOR_HDR_LEN + dim * sizeof(mp_float));
    block_init(h, MP_VECTOR_BLOCK_TYPE);
 
    return h;
}

void
mp_delete_vector        WITH_1_ARG(
        mp_vector,              a
)
/*
Deletes the vector a.
*/
{
    mem_delete_h(a);
}
