#include "defs.h"
#include "poly.h"
#include "debug.e"


t_void	
poly_delref_crf(context, apoly)
t_poly_ctx		context;
t_poly	apoly;
{
	t_pfv		elt_delete;
	t_handle	aph;
	t_polyp		ap;
	t_int		univ;
	t_int		nterms, count;
	t_poly	temp;
	t_handle	cring;

	DENY (m_poly_const(apoly));
	aph = m_poly_poly_to_handle(apoly);

	IF_DEBUG_FLAG(DEBUG_POLY,
	{
		cay_print("poly_delref_crf : delref handle %d\n", aph);
	});

	if ( block_has_other_refs( aph ) )
	{
		block_decref_delete( aph );
		return;
	}

	ap = m_poly_hdl_to_ptr(aph);
	nterms = m_polyp_nterms( ap );
	univ = m_polyp_univariate(ap);

	if (univ)
	{
		cring = m_poly_ctx_cring(context);
		elt_delete = m_poly_ctx_elt_delete(context);
	}

	for ( count = 0; count < nterms; count++ )
	{
		temp = m_polyp_coefft( ap, count );
		if (univ)
			(* elt_delete)(cring, &temp);
		else
			poly_delref_crf( context, temp );
	}
	block_decref_delete( aph );
	return;
}

t_void	
poly_elt_delete_crf(context, apoly)
t_poly_ctx	context;
t_poly	*apoly;
{
	poly_delref_crf(context, *apoly);
	*apoly = NULL_HANDLE;
	return;
}
	

t_void
poly_elt_delete ( pring,apoly)
t_handle	pring;
t_poly 	*apoly;
{
	t_poly_context	context;

	poly_init_context(pring, &context);
	poly_delref_crf(&context, *apoly);

	*apoly = NULL_HANDLE;
	return;
}
