#include "defs.h"
#include "poly.h"

t_poly
poly_mult ( pring, apoly, bpoly)
t_handle	pring;
t_poly	apoly;
t_poly	bpoly;
/*
*    POLY_MULT:  polynomial product.
*    apoly,bpoly are polynomials
*    returns apoly.bpoly
*/
{
	t_poly_context	context;

	poly_init_context(pring, &context);
	return poly_mult_crf(&context, apoly, bpoly);
}


t_poly
poly_mult_crf ( context, apoly, bpoly)
t_poly_ctx	context;
t_poly	apoly;
t_poly	bpoly;
{
	t_polyp           	ap, bp;
	t_handle           adashph;     /* t_handle to adashpoly */
	t_poly        adashpoly;
	t_polyp		adashp;
	t_poly        respoly;     /* result polynomial   */
	t_int		 res_it;
	t_poly        temp;        /* used for swapping   */
	t_int    bexpt;
	t_int    i;           /* loop counter        */
	t_int    j;           /* loop counter        */
	t_int    aterms;      /* no. terms in apoly  */
	t_int    bterms;      /* no. terms in bpoly  */
	t_pfh		elt_mult;
	t_pfh		elt_incref;
	t_pfv		elt_delete;
	t_handle	cring;
	t_int		univ;
	t_poly		acoefft, bcoefft;
	t_handle	c;
	t_logical	quo;

	elt_mult = m_poly_ctx_elt_mult(context);
	cring = m_poly_ctx_cring(context);
	elt_incref = m_poly_ctx_elt_incref(context);
	elt_delete = m_poly_ctx_elt_delete(context);

	DENY ( m_poly_const( apoly ) || m_poly_const( bpoly ) );

	/* both polynomials non_trivial */
	bp = m_poly_to_ptr( bpoly );
	ap = m_poly_to_ptr( apoly );

	bterms = m_polyp_nterms( bp );
	aterms = m_polyp_nterms( ap );

	DENY ( ( aterms == 0 ) || ( bterms == 0 ) );

	DENY ((m_polyp_princvar (ap) != m_polyp_princvar (bp)) 	||  (m_polyp_least_pvar (ap) != m_polyp_least_pvar (bp)));

	/* 
	** Term by term of bpoly apply multiplication by apoly 
	** then add resulting polynomials to obtain product.    
	*/
	/* Initialise adashpoly */
	adashpoly = poly_copy_poly_crf(context, apoly);
	adashph = m_poly_poly_to_handle( adashpoly );
	adashp = m_poly_hdl_to_ptr(adashph);

	respoly = poly_zero_poly_crf (context, apoly);

	univ = m_polyp_univariate(ap);
	quo = m_poly_ctx_quotient(context);

	for ( j = 0; j < bterms; j++ )
	{
		bexpt = m_polyp_expt( bp, j );
		bcoefft = m_polyp_coefft( bp, j );

		for ( i = 0; i < aterms; i++ )
		{
			/* remove old term from temporary polynomial */
			if (univ)
			{
				c = m_polyp_coefft(adashp,i);
				(*elt_delete)(cring, &c);
			}
			else
			{
				poly_delref_crf(context,m_polyp_coefft(adashp,i));
			}

			/* place new coefficient in temporary polynomial */
			m_polyp_expt( adashp, i ) = bexpt + m_polyp_expt( ap, i );
			acoefft = m_polyp_coefft(ap,i);
			if (univ)
			{
				(*elt_mult)(cring,acoefft,0,bcoefft,0,&c,&res_it);
				m_polyp_coefft( adashp, i ) = c;

			}
			else
			{
				m_polyp_coefft( adashp, i )
				= poly_mult_crf( context,bcoefft,acoefft);
			}
		}

		if (quo)
		{
			temp = adashpoly;
			adashpoly = poly_reduce_crf(context, adashpoly);
			ASSERT(m_poly_ctx_quotient(context));
			poly_elt_delete_crf(context, &temp);
			adashph = m_poly_poly_to_handle(adashpoly);
			adashp = m_poly_hdl_to_ptr(adashph);
		}
		temp = respoly;
		respoly = poly_add_crf(context, temp, adashpoly );
		poly_elt_delete_crf(context, &temp );

		if ( m_poly_has_other_refs( adashph ) )
		{
			/* need to create new adashpoly unless no more iterations 
			** initialise it with apoly.
			*/
			if ( j != bterms - 1 )
			{
				poly_elt_delete_crf( context, &adashpoly );
				adashpoly = poly_copy_poly_crf(context, apoly);
				adashph = m_poly_poly_to_handle( adashpoly );
				adashp = m_poly_hdl_to_ptr(adashph);

			}
		}
	}

	poly_elt_delete_crf(context, &adashpoly );
	return  respoly;

} /* poly_mult_crf */



t_poly
poly_scalar_mult (pring, apoly, aint)
t_handle	pring;
t_poly	apoly; 
t_handle	aint; 
/*
*    SCALAR_MULT: polynomial scalar product.
*    apoly is a poly, aint a scalar.
*    returns aint.apoly.
*/
{
	t_poly_context	context;

	poly_init_context(pring, &context);
	return poly_scalar_mult_crf(&context, apoly, aint);
}


t_poly
poly_scalar_mult_crf (context, apoly, aint)
t_poly_ctx	context;
t_poly	apoly; 
t_handle	aint; 
{
	t_handle           resph;       /* t_handle to respoly  */
	t_polyp		resp;
	t_polyp           ap;     
	t_poly        acoefft;
	t_int    termno;      /* loop counter       */
	t_int    nterms;      /* no. terms in apoly */

	t_poly	temp_poly;
	t_int		res_it;
	t_pfl		is_zero, is_one;
	t_pfh		elt_mult;
	t_handle	cring;


	elt_mult = m_poly_ctx_elt_mult(context);
	cring = m_poly_ctx_cring(context);
	is_zero = m_poly_ctx_is_zero(context);
	is_one = m_poly_ctx_is_one(context);

	DENY ( m_poly_const( apoly ) );

	/* general case: non_trivial polynomial */

	if ((*is_zero)(cring,  aint))
		return  poly_zero_poly_crf (context, apoly);

	if ((*is_one)(cring,  aint) )
		return  poly_elt_incref_crf (context, apoly);

	ap = m_poly_to_ptr( apoly );
	nterms = m_polyp_nterms( ap );
	m_poly_create_empty (&resph, m_polyp_princvar (ap),
					m_polyp_least_pvar (ap), nterms);
	resp = m_poly_hdl_to_ptr(resph);

	if ( m_polyp_univariate (ap))
	{
		for ( termno = 0;termno < nterms; termno++ )
		{
			/* multiply term by term */

			acoefft = m_polyp_coefft( ap, termno );
			m_polyp_expt( resp, termno ) = m_polyp_expt( ap, termno );
			(*elt_mult)(cring,acoefft,0,aint,0,&temp_poly, &res_it); 
			m_polyp_coefft( resp, termno ) = temp_poly;
		}
	}
	else
	{
		for ( termno = 0;termno < nterms; termno++ )
		{
			/* multiply term by term */

			acoefft = m_polyp_coefft( ap, termno );
			m_polyp_expt( resp, termno ) = m_polyp_expt( ap, termno );
			m_polyp_coefft( resp, termno ) = 
				poly_scalar_mult_crf( context, acoefft, aint );
		}
	}

	return  m_poly_handle_to_poly( resph );

} /* poly_scalar_mult_crf */

