#include "defs.h"
#include "poly.h"

t_poly
poly_power(pring, apoly, power)
t_handle	pring;
t_poly	apoly;
t_int		power;
/*
*        POLY_POWER :  polynomial power.
*        apoly is a polynomial , power is a non-negative beta-integer
*        returns apoly^power
*/
{
	t_poly_context	context;

	poly_init_context(pring, &context);
	return poly_power_crf(&context, apoly, power);
}

t_poly
poly_power_crf(context, apoly, power)
t_poly_ctx	context;
t_poly	apoly;
t_int		power;
{
	t_poly	bpoly;
	t_poly	cpoly;
	t_int		ndash;
	t_poly	temp;
	t_handle	cring;
	t_handle	one;


	cring = m_poly_ctx_cring(context);
	one =  ring_one(cring);
	ASSERT(power >= 0);

	DENY (m_poly_const(apoly));

	if ( power == 0 )
	{
		return  poly_constant_poly_crf (context, apoly, one);
	}

	/* apoly not constant, power non-zero, general case */

	bpoly = poly_constant_poly_crf (context, apoly, one);
	ring_elt_delete(cring, &one);
	cpoly = poly_elt_incref_crf( context, apoly );
	ndash = power;

	for ( ;; )
	{
		if ( ndash & 1 )
		{
			temp = bpoly;
			bpoly = poly_mult_crf(context, temp, cpoly );
			poly_elt_delete_crf(context, &temp );
		}

		if ( (ndash >>= 1) == 0 )
			break;

		temp = cpoly;
		cpoly = poly_mult_crf( context, temp, temp );
		poly_elt_delete_crf(context, &temp );
	}

	poly_elt_delete_crf(context, &cpoly );
	return  bpoly;

} /* poly_power_crf */

