#include "defs.h"
#include "integer.e"
#include "poly.h"
#include "poly_z_faclst.h"
#include "poly_mat.h"
#include "error.e"
#include "debug.e"


/* Installation notes : The matrices are not deallocated - this must be fixed.
** the matrices are currently under redevelopment so I have used the 
** original matrix type and I've hacked my own code to multiply them.
**
** On second thoughts, this multiplication should be kept and optimised.
** We only need small integer multiplication and the quicker we can do this
** function, the more primes we can try.
*/
/* SAC MUPDDF 
** The distinct degree factorisation is returned in the form of a 
** factor list.
** Given A, a monic, squarefree polynomial over Zp of degree >=2,
** The distinct degree factorization is a list
** L= ((n1, A1), ... , (nk, Ak))
** where n1 < n2 < ... < nk
** and Ai is the product of all monic irreducible 
** factors of A of degree ni.
*/
t_handle 	poly_u_zm_dist_deg_fact WITH_3_ARGS(
t_handle,	pring,
integer_big,	pdig,
t_poly, 	A_poly
)
{
	t_matrix		Qmatrix;
	t_poly	B_poly, C_poly;
	t_int		n;
	t_int		k, e;
	t_poly	X_poly; 
	t_poly	W_poly, D_poly;
	t_poly	temp_poly, dummy;
	t_handle	L;
	t_matrix		B_vect, temp_vect;


	/* Step 1 : Initialise */
	Qmatrix = poly_u_zm_fact_b2(pring, pdig, A_poly);
	temp_poly = poly_u_z_matrix_extract_poly(pring, Qmatrix, A_poly, 2);
	B_poly = modpoly_hom(pring, pdig, temp_poly);
	poly_z_elt_delete(pring, &temp_poly);
	/* That is - get x^pdig (mod A_poly) which is the second row. */

	IF_DEBUG_FLAG(DEBUG_POLY,
	{
		cay_print("The Qmatrix is ... \n");
		poly_z_Qmatrix_write(Qmatrix);
		cay_print("B_poly is ... \n");
		poly_z_write(pring, B_poly);
	}
	);
	C_poly = m_poly_z_incref(pring, A_poly);

	/* The highest degree of any factor is the degree of A 
	** which is also the size of the matrix
	*/
	n = poly_deg( A_poly);
	ASSERT (n == m_poly_mat_row(Qmatrix));
	ASSERT (n == m_poly_mat_col(Qmatrix));
	L = m_poly_z_faclst_alloc( n );
	k = 1;
	X_poly = poly_z_x(pring, A_poly);
	IF_DEBUG_FLAG(DEBUG_POLY,
	{
		cay_print("The value of X_poly is ... \n");
		poly_z_write(pring, X_poly);
	}
	);
	W_poly = 0;
	D_poly = 0;

	/* Step 2 : Compute Ak */
	while(1)
	{
		poly_z_elt_delete(pring, &W_poly);
		W_poly = modpoly_subtract(pring, pdig, B_poly, X_poly);
		poly_z_elt_delete(pring, &D_poly);
		D_poly = poly_u_zm_gcd(pring, pdig, W_poly, C_poly);

		if (poly_deg( D_poly) > 0)
		{
			poly_z_faclst_add_factor(L, pring, D_poly, k);
			/* We can do this because pring is a UFD and 
			** distinct k must have distinct D_poly.
			** If pring is not a UFD we can't do this 
			** since add_factor would simply add exponents.
			*/
			temp_poly = C_poly;
			modpoly_quot_rem(pring, pdig, temp_poly, D_poly, &C_poly, &dummy);
			poly_z_elt_delete(pring, &temp_poly);
			poly_z_elt_delete(pring, &dummy);
		}
		k++;
		e = poly_deg( C_poly);
		
		if (e >= 2*k)
		{
			e = poly_deg( B_poly);
			/* The following is a hack until we know what is happening
			** with the matrices
			*/
			B_vect = poly_u_z_matrix_poly_to_row(pring, B_poly, n);
			temp_vect = poly_mat_mult(B_vect, Qmatrix, pdig);
			poly_mat_delete(B_vect);
			

			poly_z_elt_delete(pring, &B_poly);
			temp_poly =  poly_u_z_matrix_extract_poly(pring, temp_vect, A_poly, 1);
			poly_mat_delete(temp_vect);
			B_poly = modpoly_hom(pring, pdig, temp_poly);
			poly_z_elt_delete(pring, &temp_poly);
			
		}
		else
		{
			if (e > 0)
			{
				poly_z_faclst_add_factor(L, pring, C_poly, e);
			}
			goto finish;
		}
	}

finish:
	poly_z_elt_delete(pring, &W_poly);
	poly_z_elt_delete(pring, &X_poly);
	poly_z_elt_delete(pring, &B_poly);
	poly_z_elt_delete(pring, &C_poly);
	poly_z_elt_delete(pring, &D_poly);
	poly_mat_delete(Qmatrix);
	

	return L;
}
