#include "defs.h"
#include "integer.e"
#include "poly.h"
#include "error.e"

t_void 
poly_u_zm_solve_eqn	WITH_9_ARGS(
t_handle, 	pring,
integer_big,	big_m,
t_poly,	apoly,
t_poly,	bpoly,
t_poly,	spoly,
t_poly,	tpoly,
t_poly,	cpoly,
t_poly *,	upoly,
t_poly *,	vpoly
)
/* 
** Modular integral univariate polynomial, solution of equation.
** Given A, B, S, T and C in Z_M[X], lc(A) is a unit, 
** deg(T) < deg(A) and A.S + B.T = 1. Calculates U and V,
** the unique elements of Z_M[X] such that A.U + B.V = C, with
** deg(V) < deg(A).
*/
{
	t_int		n, h, k, m;
	t_poly		ypoly, qpoly, jpoly, kpoly, lpoly;

	n = poly_deg( cpoly);
	h = poly_deg( apoly);
	k = poly_deg( bpoly);
	m = (n-h+1 > k) ? n-h+1 : k;

	ypoly = modpoly_mult(pring, big_m, tpoly, cpoly);
	modpoly_quot_rem(pring, big_m, ypoly, apoly, &qpoly, vpoly);

	jpoly = poly_u_z_trunc_mult(pring, m, spoly, cpoly);
	kpoly = poly_u_z_trunc_mult(pring, m, bpoly, qpoly);
	lpoly = poly_z_add(pring, jpoly, kpoly);
	*upoly = modpoly_hom(pring, big_m,  lpoly);	
	poly_z_elt_delete(pring, &jpoly);
	poly_z_elt_delete(pring, &kpoly);
	poly_z_elt_delete(pring, &lpoly);
	poly_z_elt_delete(pring, &qpoly);
	poly_z_elt_delete(pring, &ypoly);
}

#if 0
/*
SAC MIUPSE
*/


#include "defs.h"
#include "integer.e"
#include "poly.h"

t_void 
poly_u_zm_solve_eqn	WITH_9_ARGS(
t_handle, 	pring,
integer_big,	big_m,
t_poly,	apoly,
t_poly,	bpoly,
t_poly,	spoly,
t_poly,	tpoly,
t_poly,	cpoly,
t_poly *,	upoly,
t_poly *,	vpoly
)
/* 
** Modular integral univariate polynomial, solution of equation.
** Given A, B, S, T and C in Z_M[X], lc(A) is a unit, 
** deg(T) < deg(A) and A.S + B.T = 1. Calculates U and V,
** the unique elements of Z_M[X] such that A.U + B.V = C, with
** deg(V) < deg(A).
*/
{
	trbl_declarations;
	t_int		n, h, k, m;
	t_poly		ypoly, qpoly, jpoly, kpoly, lpoly;
	t_handle		aph, bph, tempph;
	t_poly		temp, respoly;
	t_int		anterms, bnterms, i, j;
	t_int		a_exp, b_exp;
	integer_big		a, b;

	n = poly_deg( cpoly);
	h = poly_deg( apoly);
	k = poly_deg( bpoly);
	m = n-h+1 > k ? n-h+1 : k;

	ypoly = modpoly_mult(pring, big_m, tpoly, cpoly);
	modpoly_quot_rem(pring, big_m, ypoly, apoly, &qpoly, vpoly);

	jpoly = poly_u_z_trunc_mult(pring, big_m, spoly, cpoly);
	kpoly = poly_u_z_trunc_mult(pring, big_m, bpoly, qpoly);
	lpoly = poly_z_add(pring, jpoly, kpoly);
	*upoly = modpoly_hom(big_m,  lpoly);	

	return;
}

#endif
