#include "defs.h"
#include "integer.e"
#include "poly.h"

void
poly_z_advance2 WITH_5_ARGS(
        t_handle,       pring,
	t_poly,	inpoly,
	t_int *,	expt,
	t_poly *,	coef,
	t_poly *,	outpoly
)
/*
*	ADV2 : extract a coef-expt pair and return the rest.
*/
{
	t_handle		iph;
	t_handle		resph;
	t_int	nts;
	t_int	term;

	if (m_poly_const (inpoly))
	{
		*expt = 0;
		*coef = m_poly_z_incref (pring, inpoly);
		*outpoly = 0;
	}
	else
	{
		iph = m_poly_poly_to_handle (inpoly);
		nts = m_poly_nterms (iph) - 1;
		*expt = m_poly_expt (iph, nts);
		*coef = m_poly_z_incref (pring, m_poly_coefft (iph, nts));
		if (nts == 0)
		{
			*outpoly = poly_z_zero_poly (pring, inpoly);
			return;
		}

		m_poly_create_empty(&resph, m_poly_princvar (iph),
                                   m_poly_least_pvar (iph), nts);
		for (term = 0; term < nts; term ++)
		{
			m_poly_coefft (resph, term) =
                    m_poly_z_incref (pring, m_poly_coefft (iph,term));
			m_poly_expt (resph, term) = m_poly_expt (iph, term);
		}
		*outpoly = m_poly_handle_to_poly (resph);
	}
#if 0
	cay_print("\n\t\t");
	poly_z_write(inpoly);
	cay_print("\n\t\tE = %d    C = ", *expt);
	poly_z_write(*coef);
	cay_print("\n\n");
#endif
}
