#include "defs.h"
#include "integer.e"
#include "poly.h"

t_poly
poly_z_chinese_rem WITH_6_ARGS(
    t_handle,         pring,
    integer_big,      M,
    t_int,    m,
    t_int,    mprime,
    t_poly,        AA,
    t_poly,        a
)
/*
** Integral polynomial chinese remainder algorithm
**
** M is a positive integer, m is a positive beta integer, gcd( m, M ) = 1.
** mprime = H_m( M )^{-1}. AA is a modular polynomial over {Z_M}prime, a is
** a modular polynomial over Z_m
**
** Returns the unique modular polynomial over Z_{Mstar} where Mstar = M*m
** which is congruent to AA modulo M and a modulo m

The pring is not the true parent ring.  The three polynomials, AA,
a, and result all have different parents.  Namely the polynomial
rings with coefficient rings Z_M, Z_m, and Z_mstar respectively.
Since all of these polynomials are usually temporary, we do not
bother to create the correct parents.  We must be careful then how
pring is used.  The information regarding the variable names and that
the polynomials have some Z_x for the coefficient ring is all that
we are assured of.

*/
{
    block_declarations;

    t_handle           AAph;
    t_poly        AAdash;
    t_poly        adash;
    t_poly        temp;
    t_poly        zero_coeff;
    t_int    terms;
    t_handle           resph;
    t_int    resterm;
    t_poly        acoefft;
    t_poly        AAcoefft;
    t_int    aexp;
    t_int    AAexp;
    t_poly        astar;
    t_int    estar;

#if 0
    cay_print ("Entering IPCRA\n");
#endif
    if ( m_poly_const( AA ) )
    {
#if 0
        cay_print ("Constant poly call mintd_cra\n");
#endif
	return  poly_z_const_chin_rem( M, m, mprime, AA, a );
    }

    AAdash = m_poly_z_incref (pring, AA);
    adash = m_poly_z_incref (pring, a);
    AAph = m_poly_poly_to_handle (AA);
    temp = m_poly_coefft (AAph, 0);
    zero_coeff  = poly_z_constant_poly (pring, temp, 0);
    terms = poly_deg( AA) + poly_deg( a) + 2;
    m_poly_create_empty(&resph, m_poly_princvar (AAph), 
                                      m_poly_least_pvar (AAph), terms);
    resterm = terms - 1;

    while ((!poly_z_is_zero_poly (pring, AAdash)) || (!poly_z_is_zero_poly (pring, adash)))
    {
        if (poly_z_is_zero_poly (pring, AAdash))
        {
            AAcoefft  = m_poly_z_incref (pring, zero_coeff);
            poly_z_advance2 (pring, adash, &estar, &acoefft, &temp);
            m_poly_z_delref (pring, adash);
            adash = temp;
        }
        else if (poly_z_is_zero_poly (pring, adash))
        {
            acoefft = m_poly_z_incref (pring, zero_coeff);
            poly_z_advance2 (pring, AAdash, &estar, &AAcoefft, &temp);
            m_poly_z_delref (pring, AAdash);
            AAdash = temp;
        }
        else
        {
            AAexp = poly_deg( AAdash);
            aexp  = poly_deg( adash);
            if (AAexp > aexp)
            {
                estar = AAexp;
                acoefft = m_poly_z_incref (pring, zero_coeff);
                poly_z_advance2 (pring, AAdash, &AAexp, &AAcoefft, &temp);
                m_poly_z_delref (pring, AAdash);
                AAdash = temp;
            }
            else if (AAexp < aexp)
            {
                estar = aexp;
                AAcoefft  = m_poly_z_incref (pring, zero_coeff);
                poly_z_advance2 (pring, adash, &aexp, &acoefft, &temp);
                m_poly_z_delref (pring, adash);
                adash = temp;
            }
            else
            {
                estar = AAexp;
                poly_z_advance2 (pring, AAdash, &AAexp, &AAcoefft, &temp);
                m_poly_z_delref (pring, AAdash);
                AAdash = temp;
                poly_z_advance2 (pring, adash, &aexp, &acoefft, &temp);
                m_poly_z_delref (pring, adash);
                adash = temp;
            }
        }
        if (m_poly_const (AAcoefft))
        {
	    astar = poly_z_const_chin_rem(M, m, mprime, AAcoefft, acoefft);
        }
        else
        {
            astar = poly_z_chinese_rem (pring, M, m, mprime, AAcoefft, acoefft);
        }

        m_poly_coefft (resph, resterm) = astar;
        m_poly_expt (resph, resterm) = estar;
        resterm --;
    }
	m_poly_z_delref(pring, adash);
	m_poly_z_delref(pring, AAdash);
    return (poly_z_clean (pring, m_poly_handle_to_poly (resph)));
}

