#include "defs.h"
#include "integer.e"
#include "poly.h"
#include "dyn_arr.h"
#include "modint.e"
#include "error.e"
#include "debug.e"


extern t_int primes[];
extern void poly_z_gcd_cofactor();


t_poly
poly_z_gcd WITH_3_ARGS (
	t_handle,      pring,
	t_poly,     apoly,
	t_poly,     bpoly
)
{
	block_declarations;
	t_poly    dummy1;
	t_poly    dummy2;
	t_poly    gcd_poly;

	poly_z_gcd_cofactor (pring, apoly, bpoly, &gcd_poly, &dummy1, &dummy2);
	m_poly_z_delref (pring, dummy1);
	m_poly_z_delref (pring, dummy2);
	return gcd_poly;
}


void
poly_z_gcd_cofactor WITH_6_ARGS (
	t_handle,      pring,
	t_poly,     Apoly,
	t_poly,     Bpoly,
	t_poly *,   Cpoly,
	t_poly *,   Abar,
	t_poly *,   Bbar
)

/* integer polynomial gcd */

{
    block_declarations;
    t_poly        Ahat, Bhat,
                     Astar, Bstar, Cstar,
                     Adash, Bdash, Cdash,
                     Ahatstar, Bhatstar, Chatstar;
    integer_big      a, b, c,
                     ahat, bhat, chat,
                     d, e, f, g,
                     abar, bbar, dbar,
                     ebar, fbar, gbar,
                     ghat, cdash,
                     chatdash,
                     Q;
    t_int    cstar, adash, bdash, cdashdash,
                     q, qdash;
    t_int    i, j, p, t;
    t_handle         temp,
                     U, V, W,
                     Ustar, Vstar, Wstar;
	t_logical			exit_loop_at_14 = FALSE;

    /* Initialize the return variables. */
    *Cpoly = *Abar = *Bbar = 0;

    /* check for constants */

    if (m_poly_const (Apoly) && m_poly_const (Bpoly))
    {
        integer_gcd_mult(Apoly, Bpoly, Cpoly, Abar, Bbar);
        return;
    }

    /* check for and deal with 0 polys */

    if (poly_z_is_zero_poly (pring, Apoly))
    {
        if (poly_z_is_zero_poly (pring, Bpoly))
        {
            *Cpoly = m_poly_z_incref( pring, Apoly);
            *Abar  = m_poly_z_incref( pring, Apoly);
            *Bbar  = m_poly_z_incref( pring, Apoly);
        }
        else
        {
            *Cpoly = poly_z_abs (pring, Bpoly);
            *Abar = poly_z_constant_poly (pring, Apoly, 0);
            *Bbar = poly_z_constant_poly (pring, Bpoly, poly_z_sign(pring, Bpoly));
        }
        return;
    }
    else if (poly_z_is_zero_poly (pring, Bpoly))
    {
        *Cpoly = poly_z_abs (pring, Apoly);
        *Bbar = poly_z_constant_poly (pring, Bpoly, 0);
        *Abar = poly_z_constant_poly (pring, Apoly,
                                           poly_z_sign(pring, Apoly));
        return;
    }

    /* Both non-zero polynomials */
	IF_DEBUG_FLAG(DEBUG_POLY,
	{ 
			cay_print ("Apoly :  "); poly_z_write (pring, Apoly);
			cay_print ("\nBpoly :  "); poly_z_write (pring, Bpoly);
			cay_print ("\n");
	}
	);

    poly_z_integer_cont_prim_part (pring, Apoly, &a, &Ahat);
    poly_z_integer_cont_prim_part (pring, Bpoly, &b, &Bhat);
    c = integer_gcd (a,b);
	IF_DEBUG_FLAG(DEBUG_POLY,
	{ 
			cay_print ("Ahat :  "); poly_z_write (pring, Ahat);
			cay_print ("\nBhat :  "); poly_z_write (pring, Bhat);
			cay_print ("\n");
	}
	);

    ahat = poly_z_lbase_coefft (pring, Ahat);
    bhat = poly_z_lbase_coefft (pring, Bhat);
    chat = integer_gcd (ahat, bhat);
    integer_delref (ahat);
    integer_delref (bhat);

    d = poly_z_max_norm (pring, Ahat);
    e = poly_z_max_norm (pring, Bhat);
    f = integer_max (d,e);
    temp = integer_add (chat, chat);
    g = integer_mult (temp, f);
    integer_delref (f);
    integer_delref (temp);

    U = poly_degree_vector (Ahat);
    V = poly_degree_vector (Bhat);

    temp = integer_power (2, poly_z_factor_coef_bound(U));
    dbar = integer_mult (d, temp);
    integer_delref (d);
    integer_delref (temp);
    temp = integer_power (2, poly_z_factor_coef_bound(V));
    ebar = integer_mult (e, temp);
    integer_delref (e);
    integer_delref (temp);
    fbar = integer_max (dbar, ebar);
    integer_delref (dbar);
    integer_delref (ebar);
    temp = integer_mult (8, c);
    gbar = integer_mult (temp, fbar);
    integer_delref (fbar);
    integer_delref (temp);

    /* W = U with first entry incremented */
    i = dyn_arr_curr_length (U);
    W = dyn_arr_alloc (i);
    dyn_arr_curr_length(W) = i;
    for (i --; i >= 0; i --)
        dyn_arr_element (W, i) = dyn_arr_element (U, i);
    dyn_arr_element (W, 0) = dyn_arr_element (W, 0) + 1;

    /* initialize here so refcounts work in step 15 */
    Q = 1;
    Adash = poly_z_constant_poly (pring, Apoly, 0);
    Bdash = m_poly_z_incref (pring, Adash);
    Cdash = m_poly_z_incref (pring, Adash);
    ghat = 0;

    /* Step 10 */
    for (p = primes[100], i = 100; i > 0; p = primes[--i])
	{
		IF_DEBUG_FLAG(DEBUG_POLY,
		{ 
				cay_print ("poly_z_gcd:  i =   %d\n", i);
				cay_print ("poly_z_gcd:  Trying prime %d\n", p);
		}
		);
        /* Step 11 */
        cstar = modint_hom (p, chat);
        if (cstar == 0)
            goto continue1;

        /* Step 12 */
        Astar = modpoly_hom (pring, p, Ahat);
        Ustar = poly_degree_vector (Astar);
        if (dyn_arr_vcomp (U, Ustar) != 0)
            goto continue2;
        Bstar = modpoly_hom (pring, p, Bhat);
        Vstar = poly_degree_vector (Bstar);
        if (dyn_arr_vcomp (V, Vstar) != 0)
            goto continue3;

        /* Step 13 */
        modpoly_gcd_cofactor (pring, p, Astar, Bstar, &Cstar, &Ahatstar, &Bhatstar);
		IF_DEBUG_FLAG(DEBUG_POLY,
		{ 
				cay_print ("Astar :  "); poly_z_write (pring, Astar);
				cay_print ("\nBstar :  "); poly_z_write (pring, Bstar);
				cay_print ("\nCstar :  "); poly_z_write (pring, Cstar);
				cay_print ("\n");
		}
		);

        /* Step 14 */
        if (poly_z_is_one_poly (pring, Cstar))
        {
            *Cpoly = poly_z_constant_poly (pring, Apoly, c);
            *Abar = poly_z_integer_div (pring, Apoly, c);
            *Bbar = poly_z_integer_div (pring, Bpoly, c);
			exit_loop_at_14 = TRUE;
            goto clean_up;
        }

        /* Step 15 */
        Wstar = poly_degree_vector (Cstar);
        t = dyn_arr_vcomp (W, Wstar);
        if (t >= 2)
        {
            integer_delref (Q);
            m_poly_z_delref (pring, Adash);
            m_poly_z_delref (pring, Bdash);
            m_poly_z_delref (pring, Cdash);
            integer_delref (ghat);
            Q = 1;
            Adash = poly_z_constant_poly (pring, Apoly, 0);
            Bdash = m_poly_z_incref (pring, Adash);
            Cdash = m_poly_z_incref (pring, Adash);
            temp = W;
            W = dyn_arr_vmin (temp, Wstar);
            block_decref_delete (temp);
            ghat = integer_incref (gbar);
            for (j = dyn_arr_curr_length(W) - 1; j >= 0; j--)
            {
                temp = ghat;
                ghat = integer_mult (temp, dyn_arr_element(W,j) + 1);
                integer_delref (temp);
            }
        }

        /* Step 16 */
        if (t == 1 || t == 3 || (t == 0 && integer_compare (Q, ghat) > 0))
            goto continue4;

        /* Step 17 */
        Chatstar = modpoly_integer_mult (pring, p, Cstar, cstar);
        qdash = modint_invert (p, modint_hom (p,Q));

        /* the SAC code uses C' and C^* */
        temp = poly_z_chinese_rem (pring, Q, p, qdash, Cdash, Chatstar);
        m_poly_z_delref (pring, Cdash);
        Cdash = temp;

        /* the SAC code uses A' and A^* */
        temp = poly_z_chinese_rem (pring, Q, p, qdash, Adash, Ahatstar);
        m_poly_z_delref (pring, Adash);
        Adash = temp;

        /* the SAC code uses B' and B* */
        temp = poly_z_chinese_rem (pring, Q, p, qdash, Bdash, Bhatstar);
        m_poly_z_delref (pring, Bdash);
        Bdash = temp;
        temp = Q;
        Q = integer_mult (temp, p);
        integer_delref (temp);

        /* Step 18 */
        if (integer_compare (Q, g) < 0)
            goto continue5;
        q = integer_log2 (Q);
        temp = modpoly_sum_norm(pring, Q, Cdash);
        cdash = integer_log2 (temp);
        integer_delref (temp);
        temp = modpoly_max_norm (pring, Q, Adash);
        adash = integer_log2 (temp);
        integer_delref (temp);
        temp = modpoly_max_norm (pring, Q, Bdash);
        bdash = integer_log2 (temp);
        integer_delref (temp);

        cdashdash = (adash > bdash ? adash : bdash);
        if (q >= cdash + cdashdash + 2)
            goto SUCCEED;

continue5 :
    m_poly_z_delref (pring, Chatstar);
continue4 :
    m_poly_z_delref (pring, Cstar);
    m_poly_z_delref (pring, Ahatstar);
    m_poly_z_delref (pring, Bhatstar);
    block_decref_delete (Wstar);
continue3 :
    block_decref_delete (Vstar);
    m_poly_z_delref (pring, Bstar);
continue2 :
    block_decref_delete (Ustar);
    m_poly_z_delref (pring, Astar);
continue1 :
    ;
    } /* end for */
    error_internal ("ran out of primes in poly_z_gcd");

SUCCEED :
    m_poly_z_delref (pring, Chatstar);
    m_poly_z_delref (pring, Cstar);
    m_poly_z_delref (pring, Ahatstar);
    m_poly_z_delref (pring, Bhatstar);
    block_decref_delete (Wstar);
    block_decref_delete (Vstar);
    m_poly_z_delref (pring, Bstar);
    block_decref_delete (Ustar);
    m_poly_z_delref (pring, Astar);

    /* Step 19 */
	temp = *Cpoly;
	*Cpoly = poly_z_shift_range (pring, temp, Q);
	m_poly_z_delref (pring, temp);
	temp = Adash;
	Adash = poly_z_shift_range (pring, temp, Q);
	m_poly_z_delref (pring, temp);
	temp = Bdash;
	Bdash = poly_z_shift_range (pring, temp, Q);
	m_poly_z_delref (pring, temp);
	temp = Cdash;
	Cdash = poly_z_shift_range (pring, temp, Q);
	m_poly_z_delref (pring, temp);
    poly_z_integer_cont_prim_part (pring, Cdash, &cdash, Cpoly);
    chatdash = integer_div (chat, cdash);
    *Abar = poly_z_integer_div (pring, Adash, chatdash);
    *Bbar = poly_z_integer_div (pring, Bdash, chatdash);
    temp = poly_z_integer_mult (pring, *Cpoly, c);
	m_poly_z_delref (pring, *Cpoly);
	*Cpoly = temp;
    abar = integer_div (a, c);
    bbar = integer_div (b, c);
    temp = *Abar;
    *Abar = poly_z_integer_mult (pring, temp, abar);
    m_poly_z_delref (pring, temp);
    temp = *Bbar;
    *Bbar = poly_z_integer_mult (pring, temp, bbar);
    m_poly_z_delref (pring, temp);
    integer_delref (abar);
    integer_delref (bbar);
    integer_delref (cdash);
    integer_delref (chatdash);

clean_up :
    /* these were created before the main loop */
    integer_delref (a);
    integer_delref (b);
    integer_delref (c);
    integer_delref (chat);
    integer_delref (g);
    integer_delref (gbar);
    integer_delref (ghat);
    integer_delref (Q);
    m_poly_z_delref (pring, Adash);
    m_poly_z_delref (pring, Bdash);
    m_poly_z_delref (pring, Cdash);
    m_poly_z_delref (pring, Ahat);
    m_poly_z_delref (pring, Bhat);
    block_decref_delete (U);
    block_decref_delete (V);
    block_decref_delete (W);

	
	if (exit_loop_at_14)
	{
			poly_z_elt_delete(pring, &Astar);
			poly_z_elt_delete(pring, &Bstar);
			poly_z_elt_delete(pring, &Cstar);
			block_decref_delete(Ustar);
			block_decref_delete(Vstar);
			poly_z_elt_delete(pring, &Bhatstar);
			poly_z_elt_delete(pring, &Ahatstar);
	}
    return;
}
