
#include "defs.h"
#include "integer.e"
#include "poly.h"

integer_big
poly_z_integer_cont_sub WITH_3_ARGS(
    t_handle,       pring,
    t_poly,      apoly,
    integer_big,     aint
)
/*
*    IPOLY_INTEGER_CONT_SUB : integral polynomial integer content subroutine.
*    apoly is an integral polynomial, aint is an integer.
*    returns the greatest common divisor of aint and the integer content
*    of apoly.
*/
{
    block_declarations;
    t_handle           aph;
    t_int    nterms;
    t_int    i;
    t_poly        coefft;
    integer_big      temp;
    integer_big      tint;

    if ( m_poly_const( apoly ) )
    {
        /* apoly constant */
        return  integer_gcd( apoly, aint );
    }

    /* apoly not constant */

    aph = m_poly_poly_to_handle( apoly );
    nterms = m_poly_nterms( aph );
    tint = integer_incref( aint );

    for ( i = 0; i < nterms; i++ )
    {
        coefft = m_poly_coefft( aph, i );

        if ( m_poly_not_const( coefft ) )
        {
	    temp = tint;
            tint = poly_z_integer_cont_sub( pring, coefft, aint );
	    integer_delref( temp );
        }
        else
        {
	    temp = tint;
            tint = integer_gcd( coefft, temp );
	    integer_delref( temp );
        }

        if ( tint == 1 )
        {
            /* GCD will remain 1 */
            return  1;
        }
    }

    return  tint;

} /* poly_z_integer_content_sub() */



integer_big
poly_z_integer_content WITH_2_ARGS(
    t_handle,    pring,
    t_poly,   apoly
)
/*
*    IPOLY_INTEGER_CONTENT :integral polynomial integer content.
*    apoly is an integral polynomial .
*    returns the integer content of apoly 
*/
{
    if ( apoly == 0 )
    {
        return( 0 );
    }

    /* return the GCD of the integer content of apoly and 0 */

    return( poly_z_integer_cont_sub( pring, apoly, 0 ) );

} /* poly_z_integer_content() */
        


void
poly_z_integer_cont_prim_part WITH_4_ARGS(
    t_handle,        pring,
    t_poly,       apoly,
    integer_big *,    paint,
    t_poly *,     pbpoly
)
/*
*    IPOLY_INTEGER_CONT_PRIM_PART : integral polynomial integer content 
*    and primitive part.
*    apoly is an integral polynomial, aint is the integer content of apoly.
*    bpoly = apoly/aint if apoly != 0
*    bpoly = 0 if apoly == 0
*/
{
    if ( apoly == 0 )
    {
        *paint = 0;
        *pbpoly = 0;
        return;
    }

    /* apoly != 0 */

    *paint = poly_z_integer_content( pring, apoly );
    *pbpoly = poly_z_integer_div( pring, apoly, *paint );

    return;

} /* poly_z_integer_cont_prim_part() */

