#include "defs.h"
#include "integer.e"
#include "poly.h"

void
poly_z_lift WITH_5_ARGS(
	t_handle,       pring,
	t_poly,      inapoly,
	t_poly,      inbpoly,
	t_poly *,    outapoly,
	t_poly *,    outbpoly
)
/*
 * lift inapoly and inbpoly into a common poly ring.
 * delref the originals.
 */
{
    t_handle        aph;
    t_int  alpvar;
    t_int  apvar;
    t_handle        bph;
    t_int  blpvar;
    t_int  bpvar;
    t_handle        tmph;

    if (m_poly_const (inapoly))
    {
        *outapoly = poly_z_constant_poly (pring, inbpoly, inapoly);
        *outbpoly = m_poly_z_incref (pring, inbpoly);
#if 0
        cay_print ("inapoly is constant\n");
        poly_z_write (pring, *outapoly);
        cay_print ("\n");
        poly_z_write (pring, *outbpoly);
        cay_print ("\n");
#endif
        return;
    }
    if (m_poly_const (inbpoly))
    {
        *outapoly = m_poly_z_incref (pring, inapoly);
        *outbpoly = poly_z_constant_poly (pring, inapoly, inbpoly);
#if 0
        cay_print ("inbpoly is constant\n");
        poly_z_write (pring, *outapoly);
        cay_print ("\n");
        poly_z_write (pring, *outbpoly);
        cay_print ("\n");
#endif
        return;
    }
    aph = m_poly_poly_to_handle (m_poly_z_incref (pring, inapoly));
    apvar = m_poly_princvar (aph);
    alpvar = m_poly_least_pvar (aph);
    bph = m_poly_poly_to_handle (m_poly_z_incref (pring, inbpoly));
    bpvar = m_poly_princvar (bph);
    blpvar = m_poly_least_pvar (bph);

    while (bpvar < apvar)
    {
        /* add more principal variables to apoly */
        apvar --;
        m_poly_create_empty(&tmph, apvar, alpvar, 1);
        m_poly_coefft (tmph, 0) = m_poly_handle_to_poly (aph);
        m_poly_expt (tmph, 0) = 0;
        aph = tmph;
    }
    while (apvar < bpvar)
    {
        /* add more principal variables to bpoly */
        bpvar --;
        m_poly_create_empty(&tmph, bpvar, blpvar, 1);
        m_poly_coefft (tmph, 0) = m_poly_handle_to_poly (bph);
        m_poly_expt (tmph, 0) = 0;
        bph = tmph;
    }

    if (alpvar < blpvar)
    {
        /* add less principal variables to apoly */
        tmph = aph;
        aph = poly_z_lift_rec (pring, tmph, bph);
        poly_z_handle_delref (pring, tmph);
    }
    else if (blpvar < alpvar)
    {
        /* add less principal variables to bpoly */
        tmph = bph;
        bph = poly_z_lift_rec (pring, tmph, aph);
        poly_z_handle_delref (pring, tmph);
    }

    *outapoly = m_poly_handle_to_poly (aph);
    *outbpoly = m_poly_handle_to_poly (bph);
#if 0
    poly_z_write (pring, *outapoly);
    cay_print ("\n");
    poly_z_write (pring, *outbpoly);
    cay_print ("\n");
#endif
    return;
}

t_handle
poly_z_lift_rec WITH_3_ARGS(
	t_handle,      pring,
	t_handle,        aph,
        t_handle,        bph
)
/*
 * Recursive part of poly_z_lift.  
 * Make aph look like bph.
 * Descend aph changing the least_pvar until the bottom.
 * Add less principal variables at the bottom of aph until it
 * has the depth of bph
 */
{
    t_handle           resph;
    t_int    nterms;
    t_int    termno;
    t_poly        model_poly;
    t_handle           model_hndl;
    t_handle           tmph;
    t_poly        tpoly;
    integer_big      temp_int;

    nterms = m_poly_nterms (aph);
    model_poly = m_poly_coefft (bph, 0);
    m_poly_create_empty(&resph, m_poly_princvar (bph),
                                        m_poly_least_pvar (bph), nterms);
    if (m_poly_univariate (aph))
    {
        for (termno = 0; termno < nterms; termno ++)
        {
            temp_int = m_poly_coefft(aph, termno);
            m_poly_expt (resph, termno) = m_poly_expt (aph, termno);
            m_poly_coefft (resph, termno) =
                     poly_z_constant_poly (pring, model_poly, temp_int);
        }
    }
    else
    {
        /* recursive */
        model_hndl = m_poly_poly_to_handle (model_poly);
        for (termno = 0; termno < nterms; termno ++)
        {
            tpoly = m_poly_coefft(aph, termno);
            m_poly_expt (resph, termno) = m_poly_expt (aph, termno);
            tmph = poly_z_lift_rec (pring, m_poly_poly_to_handle (tpoly), model_hndl);
            m_poly_coefft (resph, termno) = m_poly_handle_to_poly (tmph);
        }
    }
    return resph;
}

