#include "defs.h"
#include "integer.e"
#include "poly.h"

t_poly
poly_z_reductum WITH_2_ARGS(
    t_handle,    pring,
    t_poly,   apoly
)
/*
*    IPOLY_REDUCTUM: polynomial reductum
*    apoly is a polynomial
*    returns the reductum  of apoly
*    i.e. same poly but lacking the leading term
*/
{
    t_handle           aph;
    t_handle           resph;
    t_int    i;
    t_int    nterms;

    if ( m_poly_const( apoly ) )
    {
        return  0;
    }

    /* if apoly is not a constant then remove the leading term */

    aph = m_poly_poly_to_handle( apoly );
    nterms = m_poly_nterms( aph ) - 1;

    if ( nterms == 0 )
    {
        return  poly_z_zero_poly (pring, apoly);
    }

    m_poly_create_empty(&resph, m_poly_princvar( aph ),
                                       m_poly_least_pvar (aph), nterms );

    for ( i = 0; i < nterms; i++ )
    {
        poly_z_copy_term( pring, &resph, i, aph, i );
    }

    return  m_poly_handle_to_poly( resph );

} /* poly_z_reductum() */

