#include "defs.h"
#include "integer.e"
#include "poly.h"
#include "poly_z_faclst.h"
#include "globals.e"
#include "error.e"

t_handle
poly_z_sqf_factorize(pring, apoly)
t_handle	pring;
t_poly	apoly;
/*
** This is the front end to square_free (below)
** for the user.
*/
{
	block_declarations;
	t_handle  	flist;
	t_int	  	cont, sgn;
	t_poly	bpoly, prim;

	DENY (m_poly_const (apoly));
	ASSERT (m_poly_univariate (m_poly_poly_to_handle(apoly)));

	/*
        ** Step 1: Compute the sign, content and primitive part.
        */
        sgn = poly_z_sign(pring, apoly);
        if (sgn < 0)
                bpoly = poly_z_negate(pring, apoly);
        else
                bpoly = m_poly_z_incref(pring, apoly);
 
        poly_z_integer_cont_prim_part(pring, bpoly, &cont, &prim);
	m_poly_z_delref(pring, bpoly);
 
	/*
        ** Step 2: Degree 0 ?
        */
        if (poly_deg( prim) == 0)
        { 
                flist = m_poly_z_faclst_alloc(1);
		poly_z_faclst_add_factor(flist, pring, prim, 1);
        }
	else
	{
		flist = poly_z_square_free (pring,prim);
	}
	m_poly_z_delref(pring, prim);
	poly_z_farray_add_content(pring, sgn, cont, flist);
	return flist;
}


t_handle	poly_z_square_free WITH_2_ARGS(
t_handle,	pring,
t_poly, 	A_poly
)
/* 
** FEED ME PRIMITIVE POLYS
** SAC IPSF : Given t_poly A, return as a faclst the 
** square free factorisation of A.
** This is preprocessing for factoring polynomials.
*/
{
	t_poly	A_dash, B_poly, B_dash, C_poly, C_dash, D_poly;
	t_handle	reslist;
	t_int		j;

	/* Step 1 : initialisation */
	reslist = m_poly_z_faclst_alloc(1);
	j = 1;

	A_dash = poly_z_deriv_princvar(pring, A_poly);
	poly_z_gcd_cofactor(pring, A_poly, A_dash, &B_poly, &C_poly, &C_dash);
	poly_z_elt_delete(pring, &A_dash);

	/* Step 2 : compute factors */
	while (poly_deg( B_poly))
	{
		poly_z_elt_delete(pring, &C_dash);
		poly_z_gcd_cofactor(pring, B_poly, C_poly, &D_poly, &B_dash, &C_dash);

		if (poly_deg( C_dash) > 0 )
			poly_z_faclst_add_factor(reslist, pring, C_dash, j);

		poly_z_elt_delete(pring, &B_poly);
		B_poly = B_dash;
		poly_z_elt_delete(pring, &C_poly);
		C_poly = D_poly;
		j++;
	}
	poly_z_elt_delete(pring, &B_poly);

	/* Step 3 : finish */
	poly_z_elt_delete(pring, &C_dash);
	poly_z_faclst_add_factor(reslist, pring, C_poly, j);
	poly_z_elt_delete(pring, &C_poly);
	return reslist;
}
