#include "defs.h"
#include "integer.e"
#include "q.h"

rational
q_add WITH_3_ARGS(
	t_handle,		field,
	rational,	a,
	rational,	b
)
/*
Returns the sum of rationals a and b.
*/
{
    block_declarations;
    rational		c;
    integer_big		numer, temp1, temp2;

    if (a == 0 && b == 0)
    {
	return 0;
    }

    if (a == 0)
    {
	return q_incref(b);
    }

    if (b == 0)
    {
	return q_incref(a);
    }

    if (q_denom(a) == q_denom(b))
    {
	numer = integer_add(q_numer(a), q_numer(b));

	if (numer == 0)
	{
	    return 0;
	}

	c = q_new();
	q_numer(c) = numer;
	q_denom(c) = integer_incref(q_denom(a));
    }
    else if (q_denom(a) == -q_denom(b))
    {
	numer = integer_subtract(q_numer(a), q_numer(b));

	if (numer == 0)
	{
	    return 0;
	}

	c = q_new();
	q_numer(c) = numer;
	q_denom(c) = integer_incref(q_denom(a));
    }
    else
    {
	temp1 = integer_mult(q_numer(a), q_denom(b));
	temp2 = integer_mult(q_numer(b), q_denom(a));

	numer = integer_add(temp1, temp2);
	integer_delref(temp1);
	integer_delref(temp2);

	if (numer == 0)
	{
	    return 0;
	}

	c = q_new();
	q_numer(c) = numer;
	q_denom(c) = integer_mult(q_denom(a), q_denom(b));
    }

    q_simplify(c);

    return c;
}

