
#include "defs.h"
#include "real.e"
#include "mp.e"

t_real
real_root WITH_3_ARGS(
	t_handle,		r,
	t_real,		a,
	t_int,	n
)
/*
** Returns n'th root of a.
*/
{
	mp_float	af, f;

	real_make_mp( a, af );
	f = mp_alloc( real_base, real_beta_prec( r ));
	mp_root( af, n, f );

	return mp_to_real( f );
}


t_real
real_sqrt WITH_2_ARGS(
	t_handle,		r,
	t_real,		a
)
/*
** Returns the square root of a.
*/
{
	mp_float	af, f;

	real_make_mp( a, af );
	f = mp_alloc( real_base, real_beta_prec( r ));
	mp_sqrt( af, f );

	return mp_to_real( f );
}

