
#include "defs.h"
#include "real.e"
#include "mp.e"
#include "error.e"

t_real
real_zeta WITH_2_ARGS(
	t_handle,		r,
	t_int,	n
)
/*
** Returns Riemann zeta( n ), n > 1.
*/
{
	mp_float	xf;

	if ( ! integer_is_single( n ) )
	{
		error_internal( "n too large for Riemann zeta" );
	}
	if ( n <= 1)
	{
		error_runtime (ERR_ARG_LT_INT, 2, n, 2);
	}

	xf = mp_alloc( real_base, real_beta_prec( r ));
	mp_zeta( n, xf );

	return mp_to_real( xf );
}

