#ifndef KANT
#include "globals.e"
#include "bind.h"
#include "qm.e"
#include "quad.e"
#include "q.h"
#include "ring.e"

t_logical
z_elt_coerce WITH_7_ARGS(
        t_handle,       zring,
        t_handle,       str,
        t_handle,       elt,
        t_int,          itm,
        t_handle *,     nelt,
        t_int *,        nitm,
	t_logical,	do_error
)
/*
** Lift elt into zring
*/
{
    t_int tmp;
    block_declarations;

    ASSERT( zring == structure_z );

    switch (structure_varnum(str))
    {
    case VAR_GRP:
        switch (structure_repnum(str))
        {
        case REP_GRP_P:
        case REP_GRP_SOL:
            *nelt = grp_pc_elt_to_int(str, elt, itm);
            break;

        default:
            return FALSE;
        }
	break;

    case VAR_RING:
        switch (ring_type (str))
        {
        case RING_GFP:
        case RING_GFQ:
            *nelt = gf_int (str, elt);
            break;
        case RING_ZM:
        case RING_Z:
            *nelt = integer_incref (elt);
            break;
        case RING_Q :
            integer_quot_rem (q_numer(elt), q_denom(elt), nelt, &tmp);
            if (tmp)
            {
                integer_delref (tmp);
                integer_delref (*nelt);
                return FALSE;
            }
            break;
        case RING_QUAD :
            if (quad_is_integer(elt))
            {
                *nelt = integer_incref(quad_coef_ev(elt,0));
                break;
            }
            else
                return FALSE;
        case RING_QM :
            if (m_qmelt_is_integer (elt))
            {
                *nelt = integer_incref (elt);
                break;
            }
            for (tmp = qm_degree (str)-1; tmp > 0; tmp --)
                if (qmelt_coef(elt,tmp) != 0)
                    return FALSE;
            integer_quot_rem (qmelt_coef(elt,0), qmelt_denom(elt), nelt, &tmp);
            if (tmp)
            {
                integer_delref (tmp);
                integer_delref (*nelt);
                return FALSE;
            }
            break;

        default :
            return FALSE;
        }
	break;

    default:
        switch( structure_repnum(str) )
        {
        case REP_POW_ESEQ:
            *nelt = z_int (elt);
            break;
        case REP_CHSTR:
	    *nelt = chstr_asc(elt);
	    break;
        default:
            return FALSE;
        }
    }

    *nitm = EVAL_NO_ITEM;
    return TRUE;
}

#else /* KANT */
#include "defs.h"
#include "globals.e"
#include "q.h"
#include "integer.e"
#include "ring.e"

t_logical
z_elt_coerce WITH_7_ARGS(
        t_handle,       zring,
        t_handle,       str,
        t_handle,       elt,
        t_int,          itm,
        t_handle *,     nelt,
        t_int *,        nitm,
	t_logical,	do_error
)
/*
** Lift elt into zring
*/
{
    t_int tmp;
    block_declarations;

    ASSERT( zring == structure_z );

        switch (ring_type (str))
        {
        case RING_ZM:
        case RING_Z:
            *nelt = integer_incref (elt);
            break;
        case RING_Q :
            integer_quot_rem (q_numer(elt), q_denom(elt), nelt, &tmp);
            if (tmp)
            {
                integer_delref (tmp);
                integer_delref (*nelt);
                return FALSE;
            }
            break;
        default :
            return FALSE;
        }
	*nitm = 0;
	return TRUE;
}

#endif /* KANT */
