#include "kant.h" 
#include "anf_rel_sort.h"


vector
anf_elt_rel_norms  WITH_5_ARGS(
	order,		ord,
	order,		sub_ord,
	anf_elt,	alpha,
	anf_rel_sort,	sort,
	t_logical,      abs_value
)
/*******************************************************************************
 
Description:
 
	The function returns the relativ norm values of the element alpha in ord
	over a sub order. The vector sort contains the sorting of the 
	conjugates of ord over the sub order (n= absolute degree of the sub order)

 
Calling sequence:
 
	norm= anf_elt_rel_norms(ord, sub_ord, alpha, sort, abs);
 
      	order  	        ord      = t_handle of an order 
      	order  	        sub_ord  = t_handle of an suborder 
      	anf_elt         alpha    = t_handle of an algebraic number in ord
	vector		norm	 = norms of alpha over a sub order
	anf_rel_sort	sort	 = the sorting of the conjugates of ord
				   over the sub order   
	t_logical	abs	 = 1, if solution with exact the rel. norm of norm_elt
                                   0, if solution with the absolute value of the
                                         rel. norm of norm_elt
      
 
History:
 
	92-07-06 AJ    written
 
*******************************************************************************/
{  
	block_declarations;         

  	int		i,j;
   	t_handle          R, C;
        t_real          h1, h2, h3, one, zero;
	t_comp	        comp, comp_h1, comp_h2;
	anf_elt		beta;
	vector		norm;  
 
                                    

/*** Initialisation  **********************************************************/

        R = order_reals(ord); 
	C = comp_create(real_dec_prec(R));

	one= conv_int_to_real(R,1);  
	zero= conv_int_to_real(R,0);  

      	if (anf_elt_is_con(alpha))
		beta = anf_elt_incref(alpha);
	else
		beta = anf_elt_con(ord, alpha);    


/*** T_2-norm of alpha  *******************************************************/
 

	norm= vec_new(order_abs_degree(sub_ord));	
                  
   	for (j=1; j<= order_r1(sub_ord)+order_r2(sub_ord); j++)  
	 {                        
	  if (abs_value== FALSE)
            vec_entry(norm,j)= real_incref(one); 
	   else
	    vec_entry(norm,j)= comp_make(C, one, zero); 	   

 	  for (i=1; i<= anf_rel_sort_m(sort); i++)   
	   {
	    comp= anf_elt_ith_con(ord, beta, anf_rel_sort_ordering_elt(sort,j,i));

	    if (abs_value== FALSE)
             {
	      h1= comp_norm(C, comp);
	      h2= vec_entry(norm, j);
	      h3= real_sqrt(R, h1);
	      vec_entry(norm, j)= real_mult(R, h2, h3);
	      comp_elt_delete(C, &comp);
	      real_delete(&h1);
	      real_delete(&h2);
	      real_delete(&h3);
	     }
	    else
	     {
	      comp_h1= vec_entry(norm, j);
	      vec_entry(norm, j)= comp_mult(C, comp_h1, comp);
	      comp_elt_delete(C, &comp_h1);
	      comp_elt_delete(C, &comp);
	     }
	   } 
	  if (j>order_r1(sub_ord) )  
	    if (abs_value== FALSE)
	      vec_entry(norm, j+order_r2(sub_ord))= real_incref(vec_entry(norm, j));
             else
	      vec_entry(norm, j+order_r2(sub_ord))= comp_conjugate(C,vec_entry(norm, j));
	 }

/*** End: return the T_2-norm  ***********************************************/

	real_delete(&one); 
	real_delete(&zero); 
	anf_elt_delete(ord, &beta);
	ring_delete(&C);

	return norm;

} 

