#include "kant.h" 
#include "anf_rel_sort.h"


vector
anf_elt_rel_t2  WITH_4_ARGS(
	order,		ord,
	order,		sub_ord,
	anf_elt,	alpha,
	anf_rel_sort,	sort
)
/*******************************************************************************
 
Description:
 
	The function returns the T_2-norm values of the element alpha in ord
	over a sub order. The vector sort contains the sorting of the 
	conjugates of ord over the sub order (n= absolute degree of the sub order)

 
Calling sequence:
 
	norm= anf_elt_rel_t2(ord, alpha, sort);
 
      	order  	        ord      = t_handle of an order 
      	order  	        sub_ord  = t_handle of an suborder 
      	anf_elt         alpha    = t_handle of an algebraic number in ord
	vector		norm	 = T_2-norms of alpha over a sub order
	anf_rel_sort	sort	 = the sorting of the conjugates of ord
				   over the sub order   
      
 
History:
 
	92-04-10 AJ    written
 
*******************************************************************************/
{  
	block_declarations;         

  	int		i,j;
   	t_handle          R, C;
        t_real          h1, h2, zero;
	t_comp	        comp;
	anf_elt		beta;
	vector		norm;  
 
                                    

/*** Initialisation  **********************************************************/

        R = order_reals(ord); 
	C = comp_create(real_dec_prec(R));

	zero= conv_int_to_real(R,0);  

      	if (anf_elt_is_con(alpha))
		beta = anf_elt_incref(alpha);
	else
		beta = anf_elt_con(ord, alpha);    

	

/*** T_2-norm of alpha  *******************************************************/
 

	norm= vec_new(order_abs_degree(sub_ord));	
                  
   	for (j=1; j<= order_r1(sub_ord)+order_r2(sub_ord); j++)  
	 {
          vec_entry(norm,j)= real_incref(zero); 
 	  for (i=1; i<= anf_rel_sort_m(sort); i++)   
	   {
	    comp= anf_elt_ith_con(ord, beta, anf_rel_sort_ordering_elt(sort,j,i));
	    h1= comp_norm(C, comp);
	    h2= vec_entry(norm, j);
	    vec_entry(norm, j)= real_add(R, h2, h1);
	    comp_elt_delete(C, &comp);
	    real_delete(&h1);
	    real_delete(&h2);
	   } 
	  if (j>order_r1(sub_ord) )  
	     vec_entry(norm, j+order_r2(sub_ord))= real_incref(vec_entry(norm, j));
	 }

/*** End: return the T_2-norm  ***********************************************/

	real_delete(&zero); 
	anf_elt_delete(ord, &beta);
	ring_delete(&C);

	return norm;

} 

