#include "kant.h" 
 

matrix 
mat_comp_gram_chol WITH_2_ARGS(
        t_handle,     	C,
        matrix,     	gram
)       
/*******************************************************************************
 
AJ April 1992
Last modification: -

 
 
 
Description:
 
	This computes the positive quadratic form from a complex gram matrix.
	The coefficients of the quadratic form are computed by a variant of the 
	modificated Cholesky-method .
	

 
Calling sequence:
 
	quad= mat_comp_gram_chol(C, basis);
 
      	t_handle  	C       = t_handle the complex field
      	matrix          gram    = t_handle of a matrix
        matrix		quad    = t_handle of the Gram-matrix      
 
History:
 
	92-04-02 AJ    written
 
*******************************************************************************/        
{        
        block_declarations;

        matrix         chol; 
        integer_small  i, j, l, k; 
        t_comp         ch1, ch3, czero;
	t_real	       h1, h2, h3, h4, im, re, zero;
        integer_small  row, col;  
	t_handle 	       R;
                          
        row = mat_row(gram);
        col = mat_col(gram);

 	chol = mat_new( row, col );
    
	R= comp_real_field(C); 
	zero= conv_int_to_real(R,0);
	czero= comp_make(C, zero, zero);

	/*  chol <--- gram */

        for (i=1; i<=row; i++)
	  for (j=i; j<=col; j++) 
	    mat_elt(chol, i, j) = comp_incref(mat_elt(gram,i,j));
                         
	/*  This loops are exactly described in Fincke/Pohst and the theses of Jurk  */

        for (i=1; i< row; i++) 
	{
 	 h2 = comp_re(C, mat_elt(chol,i,i));

	 for (j=i+1; j<=col; j++) 
	  {
	   mat_elt(chol, j, i) = comp_conjugate(C, mat_elt(chol,i,j));
	   ch1 = mat_elt(chol,i,j);
	   re= comp_re(C, ch1);
	   im= comp_im(C, ch1);
	   h3= re;
	   h4= im;
	   re= real_divide(R, re, h2);
	   im= real_divide(R, im, h2);
	   real_delete(&h3);
	   real_delete(&h4);
	   mat_elt(chol,i,j)= comp_make(C, re, im);
	   real_delete(&re);
	   real_delete(&im);
	   comp_elt_delete(C, &ch1);
	  }                               

	 for (k=i+1; k<=row; k++) 
	   for (l=k; l<=col; l++) 
	    {
	     ch1=  comp_mult(C, mat_elt(chol,k,i), mat_elt(chol,i,l));
	     ch3=  mat_elt(chol, k, l); 
	     mat_elt(chol,k,l)= comp_subtract(C,ch3,ch1);
	     comp_elt_delete(C, &ch1);
	     comp_elt_delete(C, &ch3);
	    }

	 for (k=1; k<i; k++) 
	  {
	   comp_elt_delete(C, &mat_elt(chol,i,k));
	   mat_elt(chol,i,k) = comp_incref(czero);
	  }  

	 real_delete(&h2);

	}                       

        for (i=1; i<=row; i++) 
          for (k=1; k<i; k++) 
 	   {
	    comp_elt_delete(C, &mat_elt(chol,i,k));
	    mat_elt(chol,i,k) = comp_incref(czero);
	   }

	real_delete(&zero);
	comp_elt_delete(C, &czero);

        return chol;
}    

