#include "kant.h"
#include "thue.h" 

t_real
thue_bd_approximation WITH_4_ARGS( 
                thue,                   th,
                t_handle,               R,
                vector,                 alpha,
                t_real,                 E
)
/******************************************************************************

Description: 

Calling sequence: 
	
History:

*******************************************************************************/
{
	block_declarations;
 
	integer_small	deg, r;
	t_real		q, div, m_one;
        t_real          det, h1;
        order           ord;
        matrix          basis, lll_basis, dummy;

        ord = thue_order(th);
        deg = thue_abs_degree(th);
        m_one = conv_int_to_real(R, -1);
        r = order_r(ord);
        basis = thue_bd_approximation_basis(th, R, alpha, E, &div);
        
        if (thue_print_level(th) >= 6)
                {
	        puts("basis = ");
        	mat_real_write(R, basis); 
        	puts("");
        	mat_fld_det_sub(R, basis, &det);
        	printf("Det ="); real_write(R, det, 320);puts("");
                }
       	lll_basis = 0; dummy = 0;
       	lll_real_d_reduce(R, basis, 0.75, &lll_basis, &dummy);

        if (thue_print_level(th) >= 6)
                {
	        puts("lll_basis = ");
	        mat_real_write(R, lll_basis); 
	        puts("");
	        mat_fld_det_sub(R, lll_basis, &det);
        	printf("Det ="); real_write(R, det, 320);puts("");
		}
        
        mat_delref(R, &dummy);
        mat_delref(R, &basis);
        
        /********/ 
        h1 = real_divide(R, mat_elt(lll_basis, r, 1), div);
        q = real_abs(R, h1);
	real_delete(&h1);
	real_delete(&div);

        mat_delref(R, &lll_basis);     
        real_delete(&m_one);
        return q;
}

