
#include "dyn_arr.h"

/*
** faclst equivalent for integer polynomials
*/

#define m_poly_z_faclst_alloc( len ) \
		dyn_arr_alloc( (len) * 2 )

#define m_poly_z_faclst_factor( h, i ) \
		dyn_arr_element( h, (i) * 2 )

#define m_poly_z_faclst_power( h, i ) \
		dyn_arr_element( h, (i) * 2 + 1 )

#define m_poly_z_faclst_len( h ) \
		( dyn_arr_curr_length( h ) / 2 )

#define m_poly_z_faclst_len_put( h, len ) \
		( dyn_arr_curr_length( h ) = 2 * (len) )

#define m_poly_z_faclst_assure_space( h, len ) \
		dyn_arr_assure_space( h, (len) * 2, 6 )


/*
** calc space for factorise algorithm
*/

#define m_poly_z_calc_new( len ) \
		dyn_arr_alloc( ((len) + 1) * 2 )

#define m_poly_z_calc_u( h, i ) \
		dyn_arr_element( h, (i) * 2 )

#define m_poly_z_calc_a( h, i ) \
		dyn_arr_element( h, (i) * 2 + 1 )

#define m_poly_z_calc_delete( ph ) \
		mem_delete_hptr( ph )

