#include "kant.h" 
#include "rel_lattice.h" 
#include "anf_rel_sort.h" 


main()  
/*******************************************************************************
 
AJ Januar 1992
Last modification: -.

 
 
 
Description:
 
	Relative norm equation.
	
        Input format

         1)  Field 1 
         2)  Subfield
         3)  |N()| or N()  (0,1)
         4)  One solution or all solutions  (0,1)
         5)  Algebraic integer in the subfield for the relativ norm
         6)  If gammas are read or not (1,0)
         7)  r_1+r_2  Gamma values if in 5) 1 is read
        
        
	 
	Planned: -.

 
Calling sequence:
 
	-
 
History:
 
	92-06-2 AJ    written
 
*******************************************************************************/
{
	block_declarations;         
         
  	int			i,j, n, l, k, nm, m, int1, sj, tj; 
	int			sub_r1, sub_r2, sub_r1r2, subr, read_G, preci;
        double                  doub;
	t_logical		ok, abs_value, find_all;

	char			str[200];

   	t_handle          	R, Z, C;  
	order			ord, sub_ord, rel_ord, ord_h2;   
        anf_elt         	a_elt, a_elt_con, beta_elt, beta_elt_con; 

	t_real			t2_norm, h1, h2, h3, zero, loceps;  
	vector			rel_basis, rel_con;

	anf_rel_sort		sort;

	matrix			mat_h1;

	rel_lattice     	rel_lat;               
        rel_lat_enum_env	rel_env;            
	t_comp			comp_h1, comp, ctemp1, ctemp2, ctemp3, ctemp4, ctemp5;
	int 			lat_flag;

	lattice     	lat;               
        lat_enum_env	env;    

        /*  definitions for the moving of elements  */

	anf_elt			elt_h1, elt_h2, elt_h3, rel_elt, ord_elt, elt_h4, norm_elt;
	matrix			trans_pow_ord, trans_pow_sub_ord;
	matrix			trans_sub_ord_ord, trans_rel_ord;
	matrix			trans_ord_rel;
	matrix			mat_h2, mat_h3, mat_h4, mat_h5;
	integer_big 		det, trans_ord_rel_den, denom, abs_norm, abs_den;
	integer_big 		det_rel, prod_k;
	integer_small		erg, lauf1, lauf2, lauf3, lauf4, flag;
	vector			norms;
	dyn_arr_handle		store1, store2;

        /*  definitions for norm equations  */

	vector			K, G, dum1, dum2;
        dyn_arr_handle	        sol_list, normal_list;

/*** Initialisation  **********************************************************/
                                        
        preci= 30;

	kant_start();
	printf("\nrel_norm_equation.x ...... \n\n");

/*** Input loop  **************************************************************/
 
	while ( order_read(&ord) && order_read(&sub_ord) ) 
	{   
          /*** Initialisation of the orders  ***/
             
		order_reals_set(ord, preci);
		order_reals_create(ord);
		order_mult_table_create(ord); 
                order_disc_assure(ord);
		nm=  order_abs_degree(ord);  

                R = order_reals(ord);            
		zero= conv_int_to_real(R,0); 
                loceps= real_make(R, 10, -real_dec_prec(R)+2 );  
		C = comp_create(real_dec_prec(R));
	        Z= m_z_str_incref(structure_z);

		order_reals_set(sub_ord, preci);
		order_reals_create(sub_ord);      

		ord_h2= order_lll_reduce(sub_ord);
                order_delete(&sub_ord); 
	        sub_ord= order_incref(ord_h2);
                order_delete(&ord_h2);        

		order_reals_set(sub_ord, preci);
		order_reals_create(sub_ord);
		order_mult_table_create(sub_ord);
                order_disc_assure(sub_ord);
		n=  order_abs_degree(sub_ord);
		sub_r1=  order_r1(sub_ord);
		sub_r2=  order_r2(sub_ord);
		sub_r1r2=  sub_r1+sub_r2;

		if (nm%n) 
		 {
		  printf("\n\nThe second field is not a subfield!\n\n");
		  printf(  "Terminated.\n\n");  

		  goto input_false;
		 } 

		m= nm/n;
     
                                      
          /*** Shortest primitive element   ***/

		beta_elt= order_shortest_primitive_elt(sub_ord);  

                /*** Output of beta_elt           ***/

                beta_elt_con= anf_elt_con(sub_ord, beta_elt);  
               
		if (anf_print_level >=5 )
		 {
		  printf("The conjugates of a shortest primitive");
	  	  printf(" element in the sub_order:\n\n");
                  anf_elt_write(sub_ord,beta_elt); 
                  printf("  =  \n");
                  anf_elt_write(sub_ord,beta_elt_con); 
                  printf("\n");
		 }

                /*** Output of the T_2-norm of beta_elt              ***/

		t2_norm= anf_elt_t2(sub_ord, beta_elt);

		if (anf_print_level >=5 )
		 {
                  printf("T_2-norm of this element:                 "); 		 
                  real_write(R, t2_norm, 20); printf("\n\n");
		 }


          /*** Find the representation of beta_elt_con in the integral  ***/
          /*** basis of ord                                             ***/


		if (anf_elt_embed_aj(sub_ord, beta_elt, 0, ord, &a_elt))
 		 {
		  if (anf_print_level >=5 )
		   {
		    printf("Representation of this element in the extention order:\n\n");
		    printf("   ");
                    anf_elt_write(ord,a_elt); 
                    printf(" =  "); 
                    elt_h1= anf_elt_con(ord, a_elt);
                    anf_elt_write(ord,elt_h1); printf("\n");
		    anf_elt_delete(ord, &elt_h1);
		    printf("\nT2-Norm of this element: ");
		    h1= anf_elt_t2(ord, a_elt);
                    real_write(R, h1, 20); 
		    printf("\n");
		    real_delete(&h1);                    
		   }
	   	 }
		else
		 {
		  printf("The second field is not a subfield!\n\n"); 
		  goto  no_sub_order;
		 }


          /*** Find the right order of the conjugates of ord over       ***/
          /***  sub_ord                                                 ***/
		 
                a_elt_con= anf_elt_con(ord, a_elt);  

		sort= anf_con_sort_sub(ord, sub_ord, a_elt_con, beta_elt_con); 

		if (anf_print_level >=5 )
		 {
                  printf("\n\n\n\nThe conjugates of this element in the suborder:\n");
                  anf_elt_write(sub_ord,beta_elt_con); printf("\n\n");
                  printf("\nThe conjugates of this element in the extention order:\n");
                  anf_elt_write(ord,a_elt_con); printf("\n\n");
                 }                            
           
		if (anf_print_level >=5 )
		 {
                  printf("\nThe right order of the conjugates over the suborder:\n\n");
		  printf("   ");
		  for( j=1; j<= n; j++)   
	           {
		    for( i=1; i<= m; i++) 
		      printf("  %d ", anf_rel_sort_ordering_elt(sort,j,i));
	            printf("     ");
	           }
		  printf("\n");

	 	  printf("\nF^(j)'s without signature: %d \n", 2*order_r2(sub_ord));
	 	  printf("\nSignatures over F^(j): \n");
                  for (j= 1;j<= order_r1(sub_ord); j++) 
	  	   {
	 	    sj= anf_rel_sort_real_zeroes_elt(sort,j);
		    tj= anf_rel_sort_comp_zeroes_elt(sort,j);
		    printf("\nF^(%d):  s= %d,  t= %d ", j, sj, tj); 
		   }
                  printf("\n\n");      
                 }

		if (anf_print_level >=5 )
		 {
                  printf("\n\nThe sorted conjugates over the suborder:\n\n");  
		  for( j=1; j<= n; j++) 
	           {
		    for( i=1; i<=m; i++) 
		     {       
                      int1= anf_rel_sort_ordering_elt(sort,j,i);
		      comp_h1= anf_elt_ith_con(ord, a_elt_con, int1 );
		      comp_write_aj(C, comp_h1, 20);
		      printf("\n");
                      comp_elt_delete(C, &comp_h1);
		     }  
	 	    printf("\n");
	           }
		  printf("\n");                                             
                 }



          /*** Computation the solution of the norm equation     ***/

	
                if (anf_print_level>=1)
                {
                 printf("\nThe suborder: \n");
                 order_write(sub_ord);
                 printf ("\ndegree of the suborder=    %d\n",n);
                 printf (  "signatur of the suborder= (%d,%d)\n",order_r1(sub_ord),order_r2(sub_ord));
                 printf("Order discriminant= ");
   	         integer_write(order_disc(sub_ord));
	         printf("\n");

                 printf("\nThe extension order: \n");
                 order_write(ord);
                 printf ("\ndegree of the order=    %d\n",nm);
                 printf (  "signatur of the order= (%d,%d)\n",order_r1(ord),order_r2(ord));
                 printf("Order discriminant= ");
	         integer_write(order_disc(ord));
	         printf("\n");     
 
                 printf ("\nTASK: \n\n");
                }

		/* read abs_value */
               
	        scanf("%d", &abs_value);
		gets(str);
                if (anf_print_level>=1)
                 {
                  if (abs_value==1)
		   printf("Relative norm N(*) will be solve!\n");
                  else
		   printf("Relative norm |N(*)^(j)(*)| will be solve!\n");
                 }

		/* read find_all */
               
	        scanf("%d", &find_all);
		gets(str);
                if (anf_print_level>=1)
                 {
                  if (find_all==1)
	 	    printf("All solutions of N(*) will be search!\n");
                   else
		    printf("One solution of N^(j)(*) will be search!\n");
                 }

		/* read the norms K in form of an algebraic integer of sub_ord */
                          
		K= vec_new(sub_r1r2);

		norm_elt= anf_elt_read(sub_ord);
                if (anf_print_level>=1)
                 {
		  printf("Relative norm: ");
	          anf_elt_write(sub_ord, norm_elt);                  
	          printf("\n"); 
                 }

                anf_norm(sub_ord, norm_elt, &abs_norm, &abs_den);
                if (anf_print_level>=1)
                  printf("Absolute norm= ");     

	        prod_k= integer_incref(abs_norm);

                if (anf_print_level>=1)
                 {
		  integer_write(abs_norm);
	          printf("\n");
                 }

                integer_delref(abs_norm);
                integer_delref(abs_den);
                 
	  
                if (anf_print_level>=1)
		  printf("Conjugated relative norms |N(*)^(j)(*)|:  ");
      	        for (i=1;i<=sub_r1r2;i++) 
 	         {
                  comp_h1= anf_elt_ith_con(sub_ord, norm_elt, i);
 	          h1= comp_norm(C, comp_h1);
	          vec_entry(K,i)= real_sqrt(R, h1);
                  if (anf_print_level>=1)
	            real_write_aj(R, vec_entry(K,i), 15);
                  comp_elt_delete(C, &comp_h1);
                  real_delete(&h1);
	         }          
                if (anf_print_level>=1)
		  printf("\n");


	        h1= conv_int_to_real(R, 1);
     	        for (i=1;i<=sub_r1;i++) 
     	         {                                                            
	          h2= h1;
		  h1= real_mult(R,h2,vec_entry(K,i));
	          real_delete(&h2);
     	         }                         
     	        for (i=sub_r1+1;i<=sub_r1r2;i++) 
     	         {                                                            
	          h2= h1;
	          h3= real_power(R, vec_entry(K,i), 2);
		  h1= real_mult(R,h2, h3);
	          real_delete(&h2);
	          real_delete(&h3);
     	         }                         

	        real_delete(&h1);



		/* read the Gammas G */
              
		scanf("%d", &read_G); 
		gets(str);

                if(read_G)
		  {
                   G= vec_new(sub_r1r2);
                   if (anf_print_level>=1)
	   	     printf("gamma's: ");
                   for (i=1; i<= sub_r1r2; i++)
		    {
	             scanf("%lf", &doub);
		     gets(str); 
		     vec_entry(G,i)= conv_double_to_real(R, doub);
                     if (anf_print_level>=1)
	               printf("  %lf  ", doub);
		    }                   
                   if (anf_print_level>=1)
	             printf("\n");                
                  }  
                 else
                  G= MEM_NH;


                ok= rel_order_lat_norm_equation_abs(ord, sub_ord, ord, rel_con, K, &G, sort,
        		                        &sol_list, find_all, norm_elt, abs_value);
                
		if (ok)
	         {
	          if (anf_print_level >= 0)
	           {    
		    printf("\nSolution(s) found: \n\n");
		    for (l=1; l<= dyn_arr_curr_length(sol_list); l++ )
		     {
     	              anf_elt_write(ord, dyn_arr_element(sol_list,l-1) );
                      printf("\n");
	             }                      
	           }
                 }
		else
		  printf("\nNo solution found! \n");


		for (i=1; i<=dyn_arr_curr_length(sol_list); i++)
		 {
		  anf_elt_delete(ord, &dyn_arr_element(sol_list,i-1));
                
		  dyn_arr_element(sol_list,i-1)= 0;
	         }
		dyn_arr_delete(&sol_list);   



          /*** End of while loop: delete storage  ***/     

	
	        anf_elt_delete(sub_ord, &norm_elt);
		anf_rel_sort_delete(&sort); 
		vec_delete(R, &K);   
		vec_delete(R, &G);   
		anf_elt_delete (ord,&a_elt);
		anf_elt_delete (ord,&a_elt_con);  
		real_delete(&t2_norm);  

no_sub_order:	
		anf_elt_delete (sub_ord,&beta_elt);	 
		anf_elt_delete (sub_ord,&beta_elt_con); 

input_false:	real_delete(&zero);
		real_delete(&loceps);
		order_delete(&ord);
 		order_delete(&sub_ord); 

		ring_delete(&C);
		ring_delete(&Z);
                          
	} 

/*** End  *********************************************************************/
 

}         

