#include "kant.h"
#include "thue.h"


main()
	{
	block_declarations;
         
        integer_small   deg, i, precision, pri_lev;
        char            str[250];
        thue            th;
        t_real          c4, c5, h1;
        t_logical       L;
        dyn_arr_handle  delta, log_delta_r;
        t_handle        C,R, R_ord;
        order           ord;

	kant_start();
/*        mem_set_enter_check(3);       */


        pri_lev = 2;
/*        scanf("%d\n", &pri_lev);      */

for(;;){

        L = thue_read(&th);
	if (!L) break;

        thue_print_level(th) = pri_lev;

        if (thue_print_level(th) >= 1)
                thue_write(th);
        
        if (thue_print_level(th)>=2)
                printf("Creating order...\n");
        L = thue_order_create(th, 20);
        if (L == FALSE) 
                goto next;
       	
        L = thue_norm_equation(th);
        if (L == FALSE)
                {
                if (thue_print_level(th) >= 1)
                        {
                	printf("No solutions!\n");
                        }
                goto next;
                }

        if (thue_print_level(th)>=2)
                printf("Waldschmidt...\n");
        L = thue_waldschmidt(th, &c4, &c5);
        if (L == FALSE)
	        printf("Waldschmidt erfolgreich?   %d\n\n",L);
        
        if (thue_print_level(th)>=2)
                printf("Baker Reduction...\n");
        thue_baker_davenport(th, c4, c5);
        real_delete(&c4);
        real_delete(&c5);

	R = thue_reals(th);
	h1 = conv_double_to_real(R, 200.0);
	if (real_compare(R, thue_B1(th), h1) == 1)
		{
		printf("B1 is too large!  B1 = ");
		real_write(R, thue_B1(th), 20);
		puts("");
		real_delete(&thue_B1(th));
		thue_B1(th) = conv_int_to_real(R, 100);
		}
        if (thue_print_level(th)>=2)
                {
                printf("Find solutions...\n");
                }
       	L = thue_eqn_solutions(th);
       	if (L == FALSE)
       		printf("Thue_eqn_solutions erfolgreich ?   %d\n\n",L);

	if (thue_print_level(th)>=1)
		thue_solutions_print(th);

	real_delete(&h1);
next:
	thue_delete(th);
        
        if (thue_print_level(th)>=2)
                printf("====================================================================\n");

        }
}
