C      ________________________________________________________
C     |                                                        |
C     |MULTIPLY A COMPLEX HESSENBERG MATRIX BY A COMPLEX VECTOR|
C     |                                                        |
C     | INPUT:                                                 |
C     |                                                        |
C     |      X     --VECTOR                                    |
C     |                                                        |
C     |      A     --COMPLEX ARRAY WITH COEFFICIENT MATRIX     |
C     |              PACKED AT START                           |
C     |                                                        |
C     |      N     --DIMENSION OF MATRIX                       |
C     |                                                        |
C     | OUTPUT:                                                |
C     |                                                        |
C     |      Y     --PRODUCT BETWEEN A AND X                   |
C     |________________________________________________________|
C
      SUBROUTINE CEMULT(Y,X,A,N)
      COMPLEX A(1),X(1),Y(1),T
      INTEGER I,J,K,N
      IF ( N .GT. 1 ) GOTO 10
      Y(1) = A(1)*X(1)
      RETURN
10    Y(1) = (0.,0.)
      J = 0
      K = 1
20    T = X(K)
      DO 30 I = 1,K
30         Y(I) = Y(I) + T*A(I+J)
      IF ( K .EQ. N ) RETURN
      K = K + 1
      J = J + K
      Y(K) = T*A(J)
      GOTO 20
      END
