C
C      ________________________________________________________
C     |                                                        |
C     | COMPUTE ALL THE EIGENVALUES OF A GENERAL COMPLEX MATRIX|
C     |                                                        |
C     |    INPUT:                                              |
C     |                                                        |
C     |         A     --COMPLEX ARRAY CONTAINING MATRIX        |
C     |                 (LENGTH AT LEAST 1 + N(N+2))           |
C     |                                                        |
C     |         LA    --LEADING (ROW) DIMENSION OF ARRAY A     |
C     |                                                        |
C     |         N     --DIMENSION OF MATRIX STORED IN A        |
C     |                                                        |
C     |    OUTPUT:                                             |
C     |                                                        |
C     |         E     --COMPLEX ARRAY OF EIGENVALUES           |
C     |                                                        |
C     |         V     --COMPLEX ARRAY WITH AT LEAST 1+N(N+2)   |
C     |                 ELEMENTS USED AS INPUT FOR SUBROUTINE  |
C     |                 VECT WHEN EIGENVECTORS ARE COMPUTED    |
C     |                 (IF EIGENVECTORS ARE NOT DESIRED,      |
C     |                 ARGUMENT V CAN BE IDENTIFIED WITH A)   |
C     |                                                        |
C     |   PACKAGE SUBROUTINES: CAHESS,VLS                      |
C     |________________________________________________________|
C
      SUBROUTINE CVALS(E,A,LA,N,V)
      COMPLEX A(1),E(1),V(1)
      INTEGER I,J,K,L,LA,M,N
      CALL CAHESS(A,LA,N,E)
      L = 1 + N*(N+2)
      DO 10 I = 1,L
10         V(I) = A(I)
      IF ( N .GT. 1 ) GOTO 20
      E(1) = A(3)
      RETURN
20    J = 2
      K = 1
      M = 1
      L = 2
30    DO 40 I = M,L
40         A(I) = A(I+J)
      M = L + 1
      J = J + N - K
      K = K + 1
      L = M + K
      IF ( K .LT. N ) GOTO 30
      IF ( K .GT. N ) GOTO 50
      L = L - 1
      GOTO 30
50    I = (N*(N+3))/2
      J = I + N
      K = J + 1 + N/2
      CALL VLS(E,A,N,A(K),A(J),A(I))
      RETURN
      END
