C      ________________________________________________________
C     |                                                        |
C     | COMPUTE DETERMINANT OF FACTORED UPPER HESSENBERG MATRIX|
C     |                                                        |
C     |    INPUT:                                              |
C     |                                                        |
C     |         A     --EFACT'S OUTPUT                         |
C     |                                                        |
C     |    OUTPUT:                                             |
C     |                                                        |
C     |         EDET,E--DETERMINANT IS EDET*10.**E (E INTEGER) |
C     |                                                        |
C     |    BUILTIN FUNCTIONS: ABS,ALOG10,DLOG10                |
C     |________________________________________________________|
C
      FUNCTION EDET(E,A)
      REAL A(1),D,F,G
      DOUBLE PRECISION C
      INTEGER E,H,I,J,N
      D = A(1)
      IF ( ABS(D) .EQ. 1237 ) GOTO 10
      WRITE(6,*) 'ERROR: MUST FACTOR WITH EFACT BEFORE',
     1'COMPUTING DETERMINANT'
      STOP
10    E = 0
      IF ( D .LT. 0. ) GOTO 90
      D = 1.
      F = 2.**64
      G = 1./F
      H = 64
      N = A(2)
      I = 3
      J = 1
20         I = I + J
           J = J + 1
           D = D*A(I)
           IF ( J .GT. N ) GOTO 50
30         IF ( ABS(D) .LT. F ) GOTO 40
           E = E + H
           D = D*G
           GOTO 30
40         IF ( ABS(D) .GT. G ) GOTO 20
           E = E - H
           D = D*F
           GOTO 40
50    I = 5 + (N*(N+1))/2
      J = I + N + N - 2
60    IF ( A(I) .EQ. 1. ) D = -D
      I = I + 2
      IF ( I .LT. J ) GOTO 60
      IF ( E .NE. 0 ) GOTO 70
      EDET = D
      RETURN
70    IF ( D .EQ. 0. ) GOTO 100
      C = ALOG10(ABS(D)) + E*DLOG10(2.D0)
      E = C
      C = C - E
      IF ( C .LE. 0.D0 ) GOTO 80
      C = C - 1
      E = E + 1
80    F = 10.**C
      IF ( D .LT. 0. ) F = -F
      EDET = F
      RETURN
90    EDET = 0.
      RETURN
100   E = 0
      GOTO 90
      END
