C
C      ________________________________________________________
C     |                                                        |
C     |   FIND ALL THE EIGENVALUES OF A SYMMETRIC BAND MATRIX  |
C     |                                                        |
C     |    INPUT:                                              |
C     |                                                        |
C     |         A     --ARRAY CONTAINING COEFFICIENT MATRIX IN |
C     |                 COMPRESSED FORMAT                      |
C     |                                                        |
C     |         LA    --LEADING (ROW) DIMENSION OF ARRAY A     |
C     |                                                        |
C     |         N     --MATRIX DIMENSION                       |
C     |                                                        |
C     |         H     --HALF BANDWIDTH                         |
C     |                                                        |
C     |         W     --WORK ARRAY WHICH CAN BE IDENTIFIED WITH|
C     |                 ARRAY A ALTHOUGH THE ORIGINAL COEFFI-  |
C     |                 CIENTS WILL BE DESTROYED               |
C     |                 (LENGTH AT LEAST (H+1)(N-.5H+6) - 12)  |
C     |                                                        |
C     |    OUTPUT:                                             |
C     |                                                        |
C     |         E     --EIGENVALUES                            |
C     |                                                        |
C     |         D     --DIAGONAL OF REDUCED TRIDIAGONAL MATRIX |
C     |                                                        |
C     |         U     --SUPERDIAGONAL OF REDUCED MATRIX        |
C     |                                                        |
C     |         A     --THE ORIGINAL A ARRAY IS UNTOUCHED      |
C     |                 UNLESS W IS IDENTIFIED WITH A          |
C     |                                                        |
C     |    PACKAGE SUBROUTINES: HHESS,TVALS                    |
C     |________________________________________________________|
C
      SUBROUTINE HVALS(E,D,U,A,LA,N,H,W)
      REAL A(1),D(1),E(1),U(1),W(1)
      INTEGER H,LA,N
      CALL HHESS(D,U,A,LA,N,H,W)
      CALL TVALS(E,U,D,U,N,W)
      RETURN
      END
