C      ________________________________________________________
C     |                                                        |
C     |       DETERMINANT OF FACTORED TRIDIAGONAL MATRIX       |
C     |                                                        |
C     |    INPUT:                                              |
C     |                                                        |
C     |         D     --TFACT'S OUTPUT                         |
C     |                                                        |
C     |    OUTPUT:                                             |
C     |                                                        |
C     |         TDET,E--DETERMINANT IS TDET*10.**E (E INTEGER) |
C     |                                                        |
C     |    BUILTIN FUNCTIONS: ABS,ALOG10,DLOG10                |
C     |________________________________________________________|
C
      FUNCTION TDET(E,D)
      REAL D(1),F,G,T
      DOUBLE PRECISION C
      INTEGER E,H,I,L,N
      T = D(1)
      IF ( ABS(T) .EQ. 1234 ) GOTO 10
      IF ( ABS(T) .EQ. 1238 ) GOTO 10
      WRITE(6,*) 'ERROR: MUST FACTOR WITH TFACT BEFORE',
     1'COMPUTING DETERMINANT'
      STOP
10    E = 0
      IF ( T .LT. 0. ) GOTO 80
      T = 1.
      F = 65536.**4
      G = 1./F
      H = 64
      N = D(2)
      L = 3 + N
      DO 50 I = 4,L
           T = T*D(I)
20         IF ( ABS(T) .GT. F ) GOTO 40
30         IF ( ABS(T) .GT. G ) GOTO 50
           E = E - H
           T = T*F
           GOTO 30
40         E = E + H
           T = T*G
           GOTO 20
50    CONTINUE
      IF ( E .NE. 0 ) GOTO 60
      TDET = T
      RETURN
60    IF ( T .EQ. 0. ) GOTO 90
      C = ALOG10(ABS(T)) + E*DLOG10(2.D0)
      E = C
      C = C - E
      IF ( C .LE. 0.D0 ) GOTO 70
      C = C - 1
      E = E + 1
70    F = 10.**C
      IF ( T .LT. 0. ) F = -F
      TDET = F
      RETURN
80    TDET = 0.
      RETURN
90    E = 0
      GOTO 80
      END
