C      ________________________________________________________
C     |                                                        |
C     |    SOLVE THE TRANSPOSE OF A GENERAL FACTORED SYSTEM    |
C     |                                                        |
C     |    INPUT:                                              |
C     |                                                        |
C     |         A     --FACT'S OUTPUT                          |
C     |                                                        |
C     |         B     --RIGHT SIDE                             |
C     |                                                        |
C     |    OUTPUT:                                             |
C     |                                                        |
C     |         X     --SOLUTION (CAN BE IDENTIFIED WITH B     |
C     |                 ALTHOUGH THE RIGHT SIDE IS DESTROYED)  |
C     |                                                        |
C     |    BUILTIN FUNCTIONS: ABS                              |
C     |________________________________________________________|
C
      SUBROUTINE TRANS(X,A,B)
      REAL A(1),B(1),X(1),T
      INTEGER I,J,K,L,M,N
      T = A(1)
      IF ( ABS(T) .EQ. 1230 ) GOTO 10
      WRITE(6,*) 'ERROR: MUST FACTOR BEFORE SOLVING'
      STOP
10    N = A(2)
      M = N + 1
      IF ( T .LT. 0. ) GOTO 80
      T = 0.
      J = 4
      K = 1
C     -------------------------
C     |*** SKIP OVER ZEROS ***|
C     -------------------------
20    IF ( B(K) .NE. 0. ) GOTO 30
      X(K) = 0.
      K = K + 1
      IF ( K .LE. N ) GOTO 20
      RETURN
C     ---------------------------
C     |*** FORE SUBSTITUTION ***|
C     ---------------------------
30    J = J - M + M*K
40    X(K) = (B(K)-T)/A(J+K)
      IF ( K .EQ. N ) GOTO 60
      T = 0.
      J = J + M
      DO 50 I = 1,K
50         T = T + A(I+J)*X(I)
      K = K + 1
      GOTO 40
C     ---------------------------
C     |*** BACK SUBSTITUTION ***|
C     ---------------------------
60    IF ( K .EQ. 1 ) RETURN
      J = J - M
      T = X(K-1)
      DO 70 I = K,N
70         T = T - X(I)*A(I+J)
      K = K - 1
      I = A(J)
      X(K) = X(I)
      X(I) = T
      GOTO 60
C     -----------------------------
C     |*** COMPUTE NULL VECTOR ***|
C     -----------------------------
80    I = 5 + N + M*N
      L = M
90    I = I - M - 1
      L = L - 1
      IF ( A(I) .NE. 0. ) GOTO 90
      J = J + M*(L-K)
      K = L
      DO 100 I = 1,N
100        X(I) = 0.
      X(K) = 1.
110   IF ( K .EQ. N ) GOTO 60
      T = 0.
      J = J + M
      DO 120 I = L,K
120        T = T - A(I+J)*X(I)
      K = K + 1
      X(K) = T/A(J+K)
      GOTO 110
      END
