C
C      ________________________________________________________
C     |                                                        |
C     |      INVERT A TRIDIAGONAL MATRIX WITHOUT PIVOTING      |
C     |                                                        |
C     |    INPUT:                                              |
C     |                                                        |
C     |         LV    --LEADING (ROW) DIMENSION OF ARRAY V     |
C     |                                                        |
C     |         L,D,U --TFACT'S OUTPUT                         |
C     |                                                        |
C     |    OUTPUT:                                             |
C     |                                                        |
C     |         V     --INVERSE                                |
C     |                                                        |
C     |    BUILTIN FUNCTIONS: ABS                              |
C     |________________________________________________________|
C
      SUBROUTINE TVERT(V,LV,L,D,U)
      REAL D(1),L(1),U(1),V(LV,1),T
      INTEGER H,I,J,K,M,N,O
      T = D(1)
      IF ( ABS(T) .EQ. 1234 ) GOTO 10
      IF ( ABS(T) .EQ. 1238 ) GOTO 10
      WRITE(6,*) 'ERROR: MUST FACTOR WITH TFACT BEFORE INVERTING'
      STOP
10    IF ( T .GT. 0. ) GOTO 20
      WRITE(6,*) 'ERROR: MATRIX HAS NO INVERSE'
      STOP
20    N = D(2)
      IF ( N .GT. 1 ) GOTO 30
      V(1,1) = 1./D(4)
      RETURN
30    M = N - 1
      DO 110 H = 1,N
           O = H - 1
           IF ( H .EQ. 1. ) GOTO 50
           DO 40 I = 1,O
40              V(I,H) = 0.
50         V(H,H) = 1.
           O = H + 1
           IF ( O .GT. N ) GOTO 70
           J = H
C     -----------------------------
C     |*** FORWARD ELIMINATION ***|
C     -----------------------------
           DO 60 K = O,N
                V(K,H) = -V(J,H)*L(J)
60              J = K
C     ---------------------------
C     |*** BACK SUBSTITUTION ***|
C     ---------------------------
70         V(N,H) = V(N,H)/D(N+3)
           IF ( T .EQ. 1238 ) GOTO 90
           DO 80 J = 1,M
                K = N - J
80              V(K,H) = (V(K,H)-V(K+1,H)*U(K))/D(K+3)
           GOTO 110
90    DO 100 J = 1,M
           K = N - J
100        V(K,H) = V(K,H)/D(K+3) - V(K+1,H)*U(K)
110   CONTINUE
      RETURN
      END
