COMMENT

This is an example session on commutative algebra for testing the
commutative algebra package CALI.

END COMMENT;

% Example 1 : The Macaulay curve 

 vars:={u,x,y,z};
  
 setring(vars, degreeorder vars, revlex);

 setideal(m,{x*y - u*z, x**3 - u**2*y, x**2*z - u*y**2, y**3 - x*z**2});

 gbasis m;
 
 % Test whether m is prime :
 isprime m;

 % A resolution of m :
 resolve m;

 % m has depth = 1 as can be seen from the 
 gradedbettinumbers m; 

 dim m;

 % Another way to see the non perfectness of m :
 hilbseries m; 

% Example 2 : The projections of m on the coord. hyperplanes.
 
for each x in vars collect eliminate(m,{x}); 

% Example 3 : Two submodules of S^4 
  
 % Get the stored result of the earlier computation.
 r:=resolve m$

 % See whether cali!=degrees contains a relict from earlier computations.
 getdegrees(); 

 % Introduce the 2nd and 3rd syzygy module as new modules.
 % Both are submodules in in S^4.
 setmodule(m1,second r)$ setmodule(m2,third r)$ 

 gbasis m1; 
 
 % The second is already a gbasis.
 setgbasis m2; 
 
 getleadterms m1; getleadterms m2;

 % Since rk(F/M)=rk(F/in(M)), they have ranks 1 resp. 3.
 dim m1;

 indepvarsets m1;

 % Its intersection is zero :
 matintersect(m1,m2);

 % Its sum :
 setmodule(m3,matsum(m1,m2));

 gbasis m3;

 dim m3;

 % Hence it has a nontrivial annihilator :
 annihilator m3;
 
 % To get a meaningful Hilbert series make m1 homogeneous :
 setdegrees {1,x,x,x}; 
 
 % Reevaluate m1 with the new column degrees. 
 setmodule(m1,m1); 

 gbasis m1;

 hilbseries m1;

% Example 4 : A zerodimensional ideal.

 setring({x,y,z},{},lex);

 setideal(n,{x**2 + y + z - 3,x + y**2 + z - 3,x + y + z**2 - 3});

 % The groebner algorithm with factorization :
 groebfactorize n;

 % Change the term order and reevaluate n :
 setring({x,y,z},{{1,1,1}},revlex);

 setideal(n,n);

 gbasis n;

 % its primes :
 zeroprimes n;

 % a vector space basis of S/n :
 getkbase n;

 % a nontrivial radical and primary decomposition computation :
 setideal(n1,idealprod(n,{x-1,y-1,z-1}));

 gbasis n1;

 zeroradical n1;
 
 % This takes some more time :
 zeroprimarydecomposition n1;

% Example 5 : Flatten the square of a generic matrix 

 vars:={a,b,c,d};

 setring(vars,degreeorder vars,revlex);

 mm:=mat((a,b),(c,d))^2;

 setideal(n,interreduce mat2list mm);

 % a is a zero divisor, see the first equation in the 
 gbasis n; 

 resolve n$
 
 % The depth is 0 :
 bettinumbers n; 

 % The isolated prime of n :
 isolatedprimes n;

 % But n has an embedded zerodimensional component at the origin :
 pd:=primarydecomposition n;

 % Let's prove the result :
 setideal(n1,idealintersect(first first pd,first second pd));

 gbasis n1$

 modequalp(n,n1);

% Example 6 : A local computation; 
% Omega^3 of a local intersection singularity.

off noetherian;

vars:={x,y,z};

setring(vars,localorder vars,lex);

f:={x*y+z^3,x^2+y*z^2+y^5};  

setideal(p,mat2list matjac(f,vars));

interreduce p;

% Example 6 : Use of "mod".

% Polynomials modulo ideals :

setring getring m;

on noetherian;

x^2*y^2*z^2 mod m;

% Lists of polynomials modulo ideals :

{x^3,y^3,z^3,u^3} mod gbasis m;

% Matrices modulo modules :

mm:=mat((x^4,y^4,z^4,u^4));

setdegrees getdegrees m3;

mm mod m3;

mm mod gbasis m3;

% Application : Powersums through elementary symmetric functions.

vars:={a,b,c,d,e1,e2,e3,e4};

setring(vars,{},lex);

m:=interreduce {a+b+c+d-e1,
    a*b+a*c+a*d+b*c+b*d+c*d-e2,
    a*b*c+a*b*d+a*c*d+b*c*d-e3,
    a*b*c*d-e4};
    
for n:=1:5 collect a^n+b^n+c^n+d^n mod m;    

% Advanced coefficient domains :

setring({x,y,z},{},lex);

load arnum;

defpoly aa^5+3aa+2;

setideal(m,{x^2+y+z-aa,x+y^2+z-aa,x+y+z^2-aa});

gbasis m;


% The following needs some more time since factorization of arnum's
% is not so easy :
groebfactorize m;

% The factorization result offers the interesting structure of the set
% of the 8 zeroes of the system of equations, stable under a C_3-action.
iszeroradical m;

zeroprimes m;

off arnum;
off rational;

end;
